/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.dispatcher.executor;

import com.kingbase8.KBProperty;
import com.kingbase8.core.ParameterList;
import com.kingbase8.dispatcher.entity.DispatchConnection;
import com.kingbase8.dispatcher.entity.FakeConnection;
import com.kingbase8.dispatcher.executor.command.StatementCreateCommand;
import com.kingbase8.dispatcher.parser.statement.Statement;
import com.kingbase8.dispatcher.sqlParser.sql.SqlParser;
import com.kingbase8.jdbc.KbCallableStatement;
import com.kingbase8.jdbc.KbConnection;
import com.kingbase8.jdbc.KbPreparedStatement;
import com.kingbase8.jdbc.KbStatement;
import com.kingbase8.util.KBLOGGER;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;

public abstract class DispatchAbstractStatement {
    public static final int DISPATCH_TYPE_MAIN = 0;
    public static final int DISPATCH_TYPE_SLAVE = 1;
    public static final int DISPATCH_TYPE_ALL = 2;
    public static final int DISPATCH_TYPE_ALL_CURRENT = 3;
    protected DispatchConnection dispatchConnection;
    protected java.sql.Statement mainStatement;
    protected java.sql.Statement slaveStatement;
    StatementCreateCommand<? extends java.sql.Statement> createCommand;
    String strategyValue;
    String _sqlType = "NULL";
    private boolean slaveConnectionDisable;
    protected volatile int dispatchType;
    protected volatile int currentDispatchType;
    ParameterList record_main_prepl = null;
    ParameterList record_slave_prepl = null;
    java.sql.Statement record_main_stm = null;
    java.sql.Statement record_slave_stm = null;
    protected static final String TYPE_INTRANSACTION = "in transaction";
    private static final String TYPE_UPDATE_IN_INTRANSACTION = "update in transaction";
    private static final String TYPE_SELECT = "select";
    private static final String TYPE_SET = "set or reset";
    protected static final String TYPE_UPDATE = "insert or delete or update";
    private String slave_key = "";
    Statement _sqlStmt = null;
    protected int maxFieldSize = 0;
    protected int maxRows = 0;
    protected boolean escapeProcessing = true;
    protected int queryTimeout = 0;
    protected String cursorName;
    protected int fetchDirection = 1000;
    protected boolean fetchSizeModify;
    protected int fetchSize = 0;
    protected boolean poolable;
    protected boolean closeOnCompletion;

    public void cleanStatement() throws SQLException {
        if (this.mainStatement != null) {
            this.record_main_stm = this.mainStatement;
            this.mainStatement.close();
            this.mainStatement = null;
        }
        if (this.slaveStatement != null) {
            this.record_slave_stm = this.slaveStatement;
            this.slaveStatement.close();
            this.slaveStatement = null;
        }
    }

    public synchronized java.sql.Statement getMainStatement() throws SQLException {
        if (this.mainStatement == null) {
            Connection _conn = this.dispatchConnection.getMainConn();
            if (_conn instanceof FakeConnection) {
                throw new KSQLException("Master _connection is FakeConnection.", KSQLState.CONNECTION_DOES_NOT_EXIST);
            }
            this.mainStatement = this.createCommand.getStatement(_conn);
        }
        return this.mainStatement;
    }

    public List<java.sql.Statement> getAllStatement() throws SQLException {
        ArrayList<java.sql.Statement> _result = new ArrayList<java.sql.Statement>();
        _result.add(this.getMainStatement());
        int slaveCount = this.dispatchConnection.slaveCount;
        java.sql.Statement st = this.slaveStatement;
        while (slaveCount-- > 0) {
            if (this.slaveStatement != null) {
                this.slaveStatement = null;
            }
            this.slaveStatement = this.getSlaveStatement();
            if (this.slaveStatement == null) continue;
            _result.add(this.slaveStatement);
        }
        if (st != null) {
            this.resetStmtInfo(this.slaveStatement, st);
        }
        return _result;
    }

    public synchronized java.sql.Statement getSlaveStatement() throws SQLException {
        if (this.slaveStatement == null) {
            Connection _conn = null;
            int tempsttartSlaveID = 0;
            for (int j = 0; j < this.dispatchConnection.slaveCount; ++j) {
                String _key = "";
                if (KBProperty.STABLE_SLAVE.getBoolean(this.dispatchConnection.m_pros) || KBProperty.LOADBALANCE_STRATEGY.getInt(this.dispatchConnection.m_pros) == 2) {
                    _key = DispatchConnection.SLAVE + this.dispatchConnection.stable_slave_key;
                    j = this.dispatchConnection.slaveCount;
                    KBLOGGER.log(Level.INFO, "STABLE_SLAVE get _key: [SLAVE:" + _key + "] ", new Object[0]);
                } else if (KBProperty.LOADBALANCE_STRATEGY.getInt(this.dispatchConnection.m_pros) == 3) {
                    tempsttartSlaveID = this.dispatchConnection.lastSlaveID.getAndIncrement();
                    _key = DispatchConnection.SLAVE + Math.abs(tempsttartSlaveID % this.dispatchConnection.slaveCount);
                    if (!this.checkNodeLoad(_key)) {
                        if (j != this.dispatchConnection.slaveCount - 1) continue;
                        if (this.checkNodeLoad("master")) {
                            _key = null;
                            break;
                        }
                    }
                    KBLOGGER.log(Level.INFO, "CONFIG_LOAD get key: [SLAVE:" + _key + "] ", new Object[0]);
                } else if (KBProperty.LOADBALANCE_STRATEGY.getInt(this.dispatchConnection.m_pros) == 4) {
                    KBLOGGER.log(Level.INFO, "CONSUMET_TIME get _key: [SLAVE:" + _key + "] ", new Object[0]);
                } else {
                    tempsttartSlaveID = this.dispatchConnection.lastSlaveID.getAndIncrement();
                    _key = DispatchConnection.SLAVE + Math.abs(tempsttartSlaveID % this.dispatchConnection.slaveCount);
                }
                this.slave_key = _key;
                _conn = this.dispatchConnection.getSlaveConnection(_key);
                if (_conn instanceof FakeConnection) {
                    int masterport;
                    String node = this.dispatchConnection.pCMV2.nodeMap.get(((FakeConnection)_conn).getSlaveIP() + ":" + ((FakeConnection)_conn).getSlavePort());
                    String dmsg = String.format("getSlaveStatement: slave_online_ip is : {%s}  FakeConnection is: {%s}", this.dispatchConnection.pCMV2.slave_online_ip, node);
                    if (KBLOGGER.isLoggable(Level.INFO)) {
                        KBLOGGER.log(Level.INFO, dmsg, new Object[0]);
                    }
                    String sip = this.dispatchConnection.pCMV2.slave_online_ip;
                    String[] sip_arra = sip.split(",");
                    int i = 0;
                    for (i = 0; i < sip_arra.length; ++i) {
                        if (!sip_arra[i].equalsIgnoreCase(node)) continue;
                        ((FakeConnection)_conn).setSlaveStatus(true);
                        String debugmsg = String.format("getSlaveStatement: need recreate slave _connection for : {%s}", node);
                        if (!KBLOGGER.isLoggable(Level.INFO)) break;
                        KBLOGGER.log(Level.INFO, debugmsg, new Object[0]);
                        break;
                    }
                    if (((FakeConnection)_conn).getSlaveStatus()) continue;
                    String masterip = "";
                    String debugmsg = "";
                    Connection master_con = this.dispatchConnection.getMainConn();
                    if (master_con instanceof KbConnection) {
                        masterip = ((KbConnection)master_con).getHostIp();
                        masterport = ((KbConnection)master_con).getHostPort();
                        debugmsg = String.format("getSlaveStatement: offline slave connection for : {%s} and Master ip is :{%s}", node, this.dispatchConnection.pCMV2.nodeMap.get(masterip + ":" + masterport));
                    } else if (master_con instanceof FakeConnection) {
                        masterip = ((FakeConnection)master_con).getSlaveIP();
                        masterport = ((FakeConnection)master_con).getSlavePort();
                        debugmsg = String.format("getSlaveStatement: offline slave connection for : {%s} and FakeMaster ip is :{%s}", node, this.dispatchConnection.pCMV2.nodeMap.get(masterip + ":" + masterport));
                    }
                    if (!KBLOGGER.isLoggable(Level.INFO)) continue;
                    KBLOGGER.log(Level.INFO, debugmsg, new Object[0]);
                    continue;
                }
                String node = this.dispatchConnection.pCMV2.nodeMap.get(((KbConnection)_conn).getHostIp() + ":" + ((KbConnection)_conn).getHostPort());
                if (!this.dispatchConnection.pCMV2.slave_online_ip.contains(node)) {
                    KBLOGGER.log(Level.INFO, node + " can connect, but is not included in slave_online_ip.", new Object[0]);
                    _conn = null;
                    continue;
                }
                if (KBProperty.STABLE_SLAVE.getBoolean(this.dispatchConnection.m_pros) || KBProperty.LOADBALANCE_STRATEGY.getInt(this.dispatchConnection.m_pros) != 1) break;
                break;
            }
            if (_conn == null || _conn instanceof FakeConnection) {
                return null;
            }
            this.slaveStatement = this.createCommand.getStatement(_conn);
        }
        return this.slaveStatement;
    }

    public List<java.sql.Statement> getAllCurrentStatement() throws SQLException {
        ArrayList<java.sql.Statement> _result = new ArrayList<java.sql.Statement>();
        if (this.mainStatement != null) {
            _result.add(this.mainStatement);
        }
        if (this.slaveStatement != null) {
            _result.add(this.slaveStatement);
        }
        return _result;
    }

    protected int getExecuteType(String _sql) {
        int _result;
        block11: {
            _result = 0;
            if (this.strategyValue == null) {
                this.strategyValue = KBProperty.TRANSACTIONDISPATCHSTRATEGY.get(this.dispatchConnection.m_pros);
            }
            SqlParser oscarParser = new SqlParser(_sql, this.strategyValue);
            try {
                this._sqlStmt = oscarParser.doParse(this.dispatchConnection);
                this.strategyValue = oscarParser.getStrategyValue();
                this._sqlType = "NULL";
                int type = this._sqlStmt.getSQLType();
                switch (type) {
                    case 0: {
                        _result = 0;
                        this._sqlType = TYPE_INTRANSACTION;
                        this.add(1);
                        break;
                    }
                    case 1: {
                        _result = 0;
                        this._sqlType = TYPE_UPDATE_IN_INTRANSACTION;
                        this.add(1);
                        break;
                    }
                    case 2: {
                        _result = 1;
                        _result = this.changeExecuteType();
                        this._sqlType = TYPE_SELECT;
                        break;
                    }
                    case 5: {
                        _result = 2;
                        this._sqlType = TYPE_SET;
                        this.add(1 + this.dispatchConnection.slaveCount);
                        break;
                    }
                    default: {
                        _result = 0;
                        this._sqlType = TYPE_UPDATE;
                        this.add(1);
                    }
                }
                if (KBLOGGER.isLoggable(Level.INFO)) {
                    KBLOGGER.log(Level.INFO, " getExecuteType (session={0} _sql={1} _sqlType={2})", this.dispatchConnection, _sql, this._sqlType);
                }
            }
            catch (Exception e) {
                if (!KBLOGGER.isLoggable(Level.SEVERE)) break block11;
                KBLOGGER.log(Level.SEVERE, " prase (Exception={0})", e.getMessage());
                KBLOGGER.log(Level.SEVERE, e);
            }
        }
        if (this.dispatchConnection.slaveCount == 0) {
            _result = 0;
        }
        return _result;
    }

    protected int getExecuteType() {
        return this.dispatchType;
    }

    protected ParameterList recordParamlist(java.sql.Statement st) {
        ParameterList prepl = null;
        if (st instanceof KbPreparedStatement) {
            prepl = ((KbPreparedStatement)st).getPreParmlist();
        } else if (st instanceof KbCallableStatement) {
            prepl = ((KbCallableStatement)st).getPreParmlist();
        }
        return prepl;
    }

    protected void resetParamlist(java.sql.Statement st, ParameterList prepl) {
        if (st instanceof KbPreparedStatement) {
            ((KbPreparedStatement)st).setPreParmlist(prepl);
        } else if (st instanceof KbCallableStatement) {
            ((KbCallableStatement)st).setPreParmlist(prepl);
        }
    }

    protected void resetStmtInfo(java.sql.Statement current_st, java.sql.Statement record_st) {
        if (current_st instanceof KbStatement) {
            ((KbStatement)current_st).copyStatementInfo((KbStatement)record_st);
        }
        if (current_st instanceof KbPreparedStatement) {
            ((KbPreparedStatement)current_st).copyPreparedStatementInfo((KbPreparedStatement)record_st);
        }
        if (current_st instanceof KbCallableStatement) {
            ((KbCallableStatement)current_st).copyCallableStatementInfo((KbCallableStatement)record_st);
        }
    }

    private synchronized void reconnect() throws SQLException {
        if (this.dispatchConnection.isClosed()) {
            KBLOGGER.log(Level.INFO, "CloseConnectCluter and ReConnectCluter", new Object[0]);
            this.dispatchConnection.CloseConnectCluter();
            this.dispatchConnection.ReConnectCluter();
            this.dispatchConnection.CheckClusteInfo(this.dispatchConnection.m_pros);
            this.dispatchConnection.resetConnInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkNodeLoad(String slavekey) {
        KBLOGGER.log(Level.INFO, "check " + slavekey + " start ......", new Object[0]);
        if ("master".equalsIgnoreCase(slavekey)) {
            String node = this.dispatchConnection.pCMV2.master_online_ip;
            if (node == null) {
                KBLOGGER.log(Level.INFO, "master is not online", new Object[0]);
                return false;
            }
            if (this.dispatchConnection.pCMV2.loadRateMap.get(node) == null) {
                KBLOGGER.log(Level.INFO, "The rate of [current key : " + slavekey + ", current node : " + node + "] is 0.", new Object[0]);
                return false;
            }
            ConcurrentHashMap<String, AtomicInteger> concurrentHashMap = this.dispatchConnection.pCMV2.actualCounts;
            synchronized (concurrentHashMap) {
                if (this.dispatchConnection.pCMV2.actualCounts.get("all").intValue() == 0) {
                    KBLOGGER.log(Level.INFO, "Send the statement to [current key :" + slavekey + ", current node :" + node + "].", new Object[0]);
                    return true;
                }
                BigDecimal hostRate = new BigDecimal(this.dispatchConnection.pCMV2.actualCounts.get(node).get()).divide(new BigDecimal(this.dispatchConnection.pCMV2.actualCounts.get("all").get()), 2, 1);
                BigDecimal actRate = this.dispatchConnection.pCMV2.actualLoadRateMap.get(node).divide(this.dispatchConnection.pCMV2.loadRateMap.get("all"), 2, 1);
                KBLOGGER.log(Level.INFO, "current key is:" + slavekey + ", current node is:" + node + ", load is:" + hostRate, new Object[0]);
                return hostRate.compareTo(actRate) <= 0;
                {
                }
            }
        }
        Map<String, String> map = this.dispatchConnection.slaveConnInfo.get(slavekey);
        String[] ip = map.get("ADDRESS").split(",");
        String[] port = map.get("PORT").split(",");
        for (int i = 0; i < ip.length; ++i) {
            ConcurrentHashMap<String, Number> concurrentHashMap;
            String node = this.dispatchConnection.pCMV2.nodeMap.get(ip[i] + ":" + port[i]);
            if (this.dispatchConnection.pCMV2.loadRateMap.get(node) == null) {
                KBLOGGER.log(Level.INFO, "The rate of [current key : " + slavekey + ", current node : " + node + "] is 0.", new Object[0]);
                return false;
            }
            if (!this.dispatchConnection.pCMV2.slave_online_ip.contains(node) && !this.dispatchConnection.pCMV2.master_online_ip.contains(node)) {
                if (this.dispatchConnection.pCMV2.actualLoadRateMap.get(node) != null) {
                    concurrentHashMap = this.dispatchConnection.pCMV2.actualLoadRateMap;
                    synchronized (concurrentHashMap) {
                        if (this.dispatchConnection.pCMV2.actualLoadRateMap.get(node) != null) {
                            int num = this.dispatchConnection.pCMV2.actualLoadRateMap.size() - 1;
                            if (num > 0) {
                                BigDecimal add = this.dispatchConnection.pCMV2.actualLoadRateMap.get(node).divide(new BigDecimal(num), 2, 1);
                                this.dispatchConnection.pCMV2.actualLoadRateMap.remove(node);
                                for (String key : this.dispatchConnection.pCMV2.actualLoadRateMap.keySet()) {
                                    this.dispatchConnection.pCMV2.actualLoadRateMap.put(key, this.dispatchConnection.pCMV2.actualLoadRateMap.get(key).add(add));
                                }
                                KBLOGGER.log(Level.INFO, "reset load:[current key : " + slavekey + ", current node : " + node + "] is removed, other add " + add + "." + "current load:" + this.dispatchConnection.pCMV2.actualLoadRateMap, new Object[0]);
                            } else {
                                this.dispatchConnection.pCMV2.actualLoadRateMap.remove(node);
                                KBLOGGER.log(Level.INFO, "reset load:[current key : " + slavekey + ", current node : " + node + "] is removed, no nodes with rate greater than 0.", new Object[0]);
                            }
                        }
                    }
                }
                KBLOGGER.log(Level.INFO, "[current key : " + slavekey + ", current node : " + node + "] is not online.", new Object[0]);
                return false;
            }
            if (this.dispatchConnection.pCMV2.actualLoadRateMap.get(node) == null) {
                concurrentHashMap = this.dispatchConnection.pCMV2.actualLoadRateMap;
                synchronized (concurrentHashMap) {
                    if (this.dispatchConnection.pCMV2.actualLoadRateMap.get(node) == null) {
                        for (String key : this.dispatchConnection.pCMV2.loadRateMap.keySet()) {
                            if ("all".equals(key)) continue;
                            this.dispatchConnection.pCMV2.actualLoadRateMap.put(key, this.dispatchConnection.pCMV2.loadRateMap.get(key));
                        }
                        KBLOGGER.log(Level.INFO, "reset load:[current key : " + slavekey + ", current node : " + node + "] is added ." + " current load:" + this.dispatchConnection.pCMV2.actualLoadRateMap, new Object[0]);
                    }
                }
            }
            concurrentHashMap = this.dispatchConnection.pCMV2.actualCounts;
            synchronized (concurrentHashMap) {
                if (this.dispatchConnection.pCMV2.actualCounts.get("all").intValue() == 0) {
                    KBLOGGER.log(Level.INFO, "Send the statement to [current key :" + slavekey + ", current node :" + node + "].", new Object[0]);
                    return true;
                }
                BigDecimal rate = new BigDecimal(this.dispatchConnection.pCMV2.actualCounts.get(node).get()).divide(new BigDecimal(this.dispatchConnection.pCMV2.actualCounts.get("all").get()), 2, 1);
                BigDecimal actRate = this.dispatchConnection.pCMV2.actualLoadRateMap.get(node).divide(this.dispatchConnection.pCMV2.loadRateMap.get("all"), 2, 1);
                KBLOGGER.log(Level.INFO, "current key is:" + slavekey + ", current node is:" + node + ", load is:" + rate, new Object[0]);
                if (rate.compareTo(actRate) <= 0) {
                    return true;
                }
                continue;
            }
        }
        KBLOGGER.log(Level.INFO, "current load:" + this.dispatchConnection.pCMV2.actualLoadRateMap, new Object[0]);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void accumulate(java.sql.Statement st) throws SQLException {
        if (KBProperty.LOADBALANCE_STRATEGY.getInt(this.dispatchConnection.m_pros) == 3) {
            ConcurrentHashMap<String, AtomicInteger> concurrentHashMap = this.dispatchConnection.pCMV2.actualCounts;
            synchronized (concurrentHashMap) {
                String node = this.dispatchConnection.pCMV2.nodeMap.get(((KbConnection)st.getConnection()).getHostIp() + ":" + ((KbConnection)st.getConnection()).getHostPort());
                this.dispatchConnection.pCMV2.actualCounts.get(node).getAndAdd(1);
                this.dispatchConnection.pCMV2.actualCounts.get("all").getAndAdd(1);
            }
        }
    }

    protected <R> R executeTemplet(ExecuteCommand<R> command, int dispatchType) throws SQLException {
        String debugmsg;
        this.currentDispatchType = dispatchType;
        R r = null;
        StringBuilder _sql = null;
        java.sql.Statement st = null;
        if (KBLOGGER.isLoggable(Level.INFO)) {
            _sql = new StringBuilder();
            _sql.append("Main session: ").append(this.dispatchConnection).append(", ").append(DispatchAbstractStatement.class).append(", executeTemplet()" + command.getFunctionName() + " ,dispatchType :").append(dispatchType + " ");
            debugmsg = String.format("executeTemplet (Main session={%s} command={%s} dispatchType={%s})", this.dispatchConnection, command.getFunctionName(), dispatchType);
            KBLOGGER.log(Level.INFO, debugmsg, new Object[0]);
        }
        if (this.dispatchConnection.getLastSqlType() != null && this.dispatchConnection.getLastSqlType().equals(TYPE_INTRANSACTION)) {
            this._sqlType = TYPE_INTRANSACTION;
        }
        AtomicLong t1 = new AtomicLong(System.currentTimeMillis());
        block12 : switch (dispatchType) {
            case 0: {
                try {
                    st = this.getMainStatement();
                    if (command.isExecuteFunction()) {
                        this.resetStatement(st);
                    }
                    if (KBLOGGER.isLoggable(Level.INFO) && command.isExecuteFunction()) {
                        debugmsg = String.format("Send to master session: (session={%s} url={%s} st={%s} _sqlType={%s})", this.dispatchConnection, ((KbConnection)st.getConnection()).getURL(), st, this._sqlType);
                        KBLOGGER.log(Level.INFO, debugmsg, new Object[0]);
                    }
                    this.accumulate(st);
                    r = command.execute(st);
                    if (this.dispatchConnection.getAutoCommit() || !command.isExecuteFunction() || !this._sqlType.equalsIgnoreCase(TYPE_UPDATE)) break;
                    this.dispatchConnection.setHasUpdate(true);
                    this._sqlType = TYPE_INTRANSACTION;
                    if (!KBLOGGER.isLoggable(Level.INFO)) break;
                    KBLOGGER.log(Level.INFO, "Enter transactional state from _sql[" + this._sqlStmt.getCommandText() + "].", new Object[0]);
                    break;
                }
                catch (SQLException e) {
                    if (this.expectionHandler(e, null, null) && (this._sqlType.equalsIgnoreCase(TYPE_SELECT) || !this._sqlType.equalsIgnoreCase(TYPE_INTRANSACTION) && KBProperty.WRITE_IS_RETRY.getBoolean(this.dispatchConnection.m_pros)) && !command.getFunctionName().contains("executeBatch") && this.dispatchConnection.retrytimes > 0) {
                        if (KBLOGGER.isLoggable(Level.WARNING) && st != null) {
                            KBLOGGER.log(Level.WARNING, "Error Main stmt url:" + ((KbConnection)st.getConnection()).getURL() + "\n", new Object[0]);
                        }
                        int looperation = this.dispatchConnection.retrytimes;
                        int interval = this.dispatchConnection.retryinterval;
                        while (looperation-- > 0) {
                            try {
                                if (this.dispatchConnection.isClosed()) {
                                    this.reconnect();
                                    if (!this.dispatchConnection.CheckIsMaster(this.dispatchConnection.getMainConn())) {
                                        if (KBLOGGER.isLoggable(Level.WARNING)) {
                                            KBLOGGER.log(Level.WARNING, "Connect Main _error retry _connect:" + looperation + "\n", new Object[0]);
                                        }
                                        Thread.sleep(interval * 1000);
                                        continue;
                                    }
                                }
                                this.cleanStatement();
                                st = this.getMainStatement();
                                if (this.record_main_stm != null) {
                                    this.resetStmtInfo(st, this.record_main_stm);
                                }
                                if (KBLOGGER.isLoggable(Level.WARNING)) {
                                    debugmsg = String.format("Send to master stmt, send to master session: (session={%s} url={%s} st={%s} _sqlType={%s})", this.dispatchConnection, ((KbConnection)st.getConnection()).getURL(), st, this._sqlType);
                                    KBLOGGER.log(Level.WARNING, debugmsg, new Object[0]);
                                }
                                this.accumulate(st);
                                r = command.execute(st);
                                if (!this.dispatchConnection.getAutoCommit() && command.isExecuteFunction() && this._sqlType.equalsIgnoreCase(TYPE_UPDATE)) {
                                    this.dispatchConnection.setHasUpdate(true);
                                    this._sqlType = TYPE_INTRANSACTION;
                                    if (KBLOGGER.isLoggable(Level.WARNING)) {
                                        KBLOGGER.log(Level.WARNING, "Enter transactional state from _sql[" + this._sqlStmt.getCommandText() + "].", new Object[0]);
                                    }
                                }
                                this.currentDispatchType = 0;
                                this.dispatchType = 0;
                                break block12;
                            }
                            catch (SQLException ei) {
                                if (!this.expectionHandler(ei, null, null)) {
                                    throw ei;
                                }
                                if (KBLOGGER.isLoggable(Level.WARNING)) {
                                    debugmsg = String.format("Send to master SQLException: (ei.getSQLState={%s},ei.getMessage={%s})", ei.getSQLState(), ei.getMessage());
                                    KBLOGGER.log(Level.WARNING, debugmsg, new Object[0]);
                                }
                                if (looperation > 0) {
                                    if (KBLOGGER.isLoggable(Level.WARNING)) {
                                        KBLOGGER.log(Level.WARNING, "Connect Main _error retry _connect:" + looperation + " Exception \n", new Object[0]);
                                    }
                                    try {
                                        Thread.sleep(interval * 1000);
                                    }
                                    catch (InterruptedException e1) {
                                        if (!Thread.interrupted()) continue;
                                        KBLOGGER.log(Level.SEVERE, e1);
                                    }
                                    continue;
                                }
                                debugmsg = String.format("Send to master retry maximnum times still SQLException.\nCurrent business exception: %s", ei.getMessage());
                                String msg = this.constructExceptionMessage(debugmsg, e);
                                this.dispatchConnection.close();
                                ei.addSuppressed(e);
                                if (KBLOGGER.isLoggable(Level.SEVERE)) {
                                    KBLOGGER.log(Level.SEVERE, msg, new Object[0]);
                                    KBLOGGER.log(Level.SEVERE, ei);
                                }
                                throw new SQLException(msg, ei.getSQLState(), ei);
                            }
                            catch (InterruptedException e1) {
                                if (!Thread.interrupted()) continue;
                                KBLOGGER.log(Level.SEVERE, e1);
                            }
                        }
                        break;
                    }
                    if (this.expectionHandler(e, null, null)) {
                        this.dispatchConnection.close();
                    }
                    StringBuffer msg = new StringBuffer();
                    msg.append(e.getMessage() + "\n");
                    msg.append(this.getMonitorExceptionMessage());
                    if (KBLOGGER.isLoggable(Level.SEVERE)) {
                        debugmsg = String.format("failare execute in Master Exception: (e.getSQLState={%s},e.getMessage={%s})", e.getSQLState(), e.getMessage());
                        KBLOGGER.log(Level.SEVERE, debugmsg, new Object[0]);
                        KBLOGGER.log(Level.SEVERE, msg.toString(), new Object[0]);
                    }
                    throw new SQLException(msg.toString(), e.getSQLState(), e);
                }
            }
            case 1: {
                try {
                    st = this.getSlaveStatement();
                    if (st == null) {
                        this.currentDispatchType = 0;
                        st = this.getMainStatement();
                        if (command.isExecuteFunction()) {
                            this.resetStatement(st);
                        }
                        this.slaveStatement = st;
                        this.record_slave_stm = st;
                        if (KBLOGGER.isLoggable(Level.INFO) && command.isExecuteFunction()) {
                            debugmsg = String.format("getSlaveStatement _error ,send to master session: (session={%s} url={%s} st={%s} _sqlType={%s})", this.dispatchConnection, ((KbConnection)st.getConnection()).getURL(), st, this._sqlType);
                            KBLOGGER.log(Level.INFO, debugmsg, new Object[0]);
                        }
                        this.accumulate(st);
                        r = command.execute(st);
                        break;
                    }
                    if (command.isExecuteFunction() && this._sqlType.equalsIgnoreCase(TYPE_INTRANSACTION)) {
                        this.currentDispatchType = 0;
                        this.dispatchType = 0;
                        this.cleanStatement();
                        st = this.getMainStatement();
                        if (this.record_slave_stm != null) {
                            this.resetStmtInfo(st, this.record_slave_stm);
                        }
                        this.resetStatement(st);
                        if (KBLOGGER.isLoggable(Level.INFO)) {
                            debugmsg = String.format("change this to master db: (master={%s}).Send to master session: (session={%s} url={%s} st={%s} _sqlType={%s})", ((KbConnection)st.getConnection()).getHostIp(), this.dispatchConnection, ((KbConnection)st.getConnection()).getURL(), st, this._sqlType);
                            KBLOGGER.log(Level.INFO, debugmsg, new Object[0]);
                        }
                        this.accumulate(st);
                        r = command.execute(st);
                        break;
                    }
                    if (KBLOGGER.isLoggable(Level.INFO) && command.isExecuteFunction()) {
                        debugmsg = String.format("Send to slave session: (session={%s} url={%s} st={%s} _sqlType={%s})", this.dispatchConnection, ((KbConnection)st.getConnection()).getURL(), st, this._sqlType);
                        KBLOGGER.log(Level.INFO, debugmsg, new Object[0]);
                    }
                    if (command.isExecuteFunction()) {
                        this.resetStatement(st);
                    }
                    this.accumulate(st);
                    r = command.execute(st);
                    break;
                }
                catch (SQLException e) {
                    if (command.getFunctionName().contains("executeBatch")) {
                        if (this.expectionHandler(e, null, null)) {
                            this.dispatchConnection.close();
                        }
                        StringBuffer msg = new StringBuffer();
                        msg.append(e.getMessage() + "\n");
                        msg.append(this.getMonitorExceptionMessage());
                        throw new SQLException(msg.toString(), e.getSQLState(), e);
                    }
                    int looperation = this.dispatchConnection.retrytimes;
                    if (looperation == 0 && this.currentDispatchType == 1 && !this.expectionHandler(e, null, null)) {
                        ++looperation;
                    }
                    if (looperation <= 0) {
                        this.dispatchConnection.close();
                        StringBuffer msg = new StringBuffer();
                        msg.append(e.getMessage() + "\n");
                        msg.append(this.getMonitorExceptionMessage());
                        throw new SQLException(msg.toString(), e.getSQLState(), e);
                    }
                    int interval = this.dispatchConnection.retryinterval;
                    SQLException excep = e;
                    while (looperation-- > 0) {
                        try {
                            if (this.currentDispatchType == 1) {
                                if (this.expectionHandler(excep, null, null)) {
                                    FakeConnection fakeConnection = this.dispatchConnection.setSlaveToFakebyKey(this.slave_key);
                                    fakeConnection.addSqlException(new SQLException("The _connection execution failure is set as fakeConnection"));
                                    this.cleanStatement();
                                    st = this.getSlaveStatement();
                                    if (st != null) {
                                        this.resetStmtInfo(st, this.record_slave_stm);
                                        if (KBLOGGER.isLoggable(Level.WARNING)) {
                                            debugmsg = String.format("Send to slave exception: (%s) ,change this to anoter slave db: (slave={%s}).Send to slave session: (session={%s} url={%s} st={%s} _sqlType={%s})", e.getMessage(), ((KbConnection)st.getConnection()).getHostIp(), this.dispatchConnection, ((KbConnection)st.getConnection()).getURL(), st, this._sqlType);
                                            KBLOGGER.log(Level.WARNING, debugmsg, new Object[0]);
                                        }
                                        this.accumulate(st);
                                        r = command.execute(st);
                                        break block12;
                                    }
                                }
                                this.currentDispatchType = 0;
                                this.dispatchType = 0;
                                this.cleanStatement();
                                st = this.getMainStatement();
                                if (this.record_slave_stm != null) {
                                    this.resetStmtInfo(st, this.record_slave_stm);
                                }
                                if (KBLOGGER.isLoggable(Level.WARNING)) {
                                    debugmsg = String.format("Send to slave exception: (%s) ,change this to master db: (master={%s}).Send to master session: (session={%s} url={%s} st={%s} _sqlType={%s})", e.getMessage(), ((KbConnection)st.getConnection()).getHostIp() + ":" + ((KbConnection)st.getConnection()).getHostPort(), this.dispatchConnection, ((KbConnection)st.getConnection()).getURL(), st, this._sqlType);
                                    KBLOGGER.log(Level.WARNING, debugmsg, new Object[0]);
                                }
                                this.accumulate(st);
                                r = command.execute(st);
                                break block12;
                            }
                            this.currentDispatchType = 0;
                            this.dispatchType = 0;
                            if (this.dispatchConnection.isClosed()) {
                                this.reconnect();
                                if (this.dispatchConnection.getMainConn() == null) {
                                    if (KBLOGGER.isLoggable(Level.WARNING)) {
                                        KBLOGGER.log(Level.WARNING, "Connect Main _error retry _connect:" + looperation + "\n", new Object[0]);
                                    }
                                    Thread.sleep(interval * 1000);
                                    continue;
                                }
                            }
                            this.cleanStatement();
                            st = this.getMainStatement();
                            if (this.record_main_stm != null) {
                                this.resetStmtInfo(st, this.record_main_stm);
                            }
                            if (KBLOGGER.isLoggable(Level.WARNING)) {
                                debugmsg = String.format("Send switch slave to master session, send to master session: (session={%s} url={%s} st={%s} _sqlType={%s})", this.dispatchConnection, ((KbConnection)st.getConnection()).getURL(), st, this._sqlType);
                                KBLOGGER.log(Level.WARNING, debugmsg, new Object[0]);
                            }
                            this.accumulate(st);
                            r = command.execute(st);
                            break block12;
                        }
                        catch (SQLException ei) {
                            if (!this.expectionHandler(ei, null, null)) {
                                throw ei;
                            }
                            excep = ei;
                            if (KBLOGGER.isLoggable(Level.WARNING)) {
                                debugmsg = String.format("Send to master from switch slave SQLException: (ei.getSQLState={%s},ei.getMessage={%s})", ei.getSQLState(), ei.getMessage());
                                KBLOGGER.log(Level.WARNING, debugmsg, new Object[0]);
                            }
                            if (looperation > 0) {
                                try {
                                    Thread.sleep(interval * 1000);
                                }
                                catch (InterruptedException e1) {
                                    if (!Thread.interrupted()) continue;
                                    KBLOGGER.log(Level.SEVERE, e1);
                                }
                                continue;
                            }
                            debugmsg = String.format("Send to master from switch slave retry failare maxtimes still SQLException.\nCurrent business exception: %s", ei.getMessage());
                            String msg = this.constructExceptionMessage(debugmsg, e);
                            this.dispatchConnection.close();
                            ei.addSuppressed(e);
                            if (KBLOGGER.isLoggable(Level.WARNING)) {
                                KBLOGGER.log(Level.WARNING, debugmsg, new Object[0]);
                                KBLOGGER.log(Level.WARNING, ei.getMessage(), new Object[0]);
                            }
                            throw new SQLException(msg, ei.getSQLState(), ei);
                        }
                        catch (InterruptedException e1) {
                            if (!Thread.interrupted()) continue;
                            KBLOGGER.log(Level.SEVERE, e1);
                        }
                    }
                    break;
                }
            }
            case 2: {
                List<java.sql.Statement> list = null;
                try {
                    if (KBLOGGER.isLoggable(Level.INFO) && command.isExecuteFunction()) {
                        debugmsg = String.format("Send to all session: (_sql={%s}, _sqlType={%s})", _sql.toString(), this._sqlType);
                        KBLOGGER.log(Level.INFO, debugmsg, new Object[0]);
                    }
                    list = this.getAllStatement();
                    Iterator<java.sql.Statement> i$ = list.iterator();
                    while (i$.hasNext()) {
                        java.sql.Statement stm;
                        st = stm = i$.next();
                        if (command.isExecuteFunction()) {
                            this.resetStatement(st);
                        }
                        this.accumulate(st);
                        r = command.execute(st);
                    }
                }
                catch (SQLException e) {
                    if (!this.expectionHandler(e, null, null) && st != null && ((KbConnection)st.getConnection()).isSlave()) break;
                    if (this.expectionHandler(e, null, null) && (this._sqlType.equals("NULL") || !this._sqlType.equalsIgnoreCase(TYPE_INTRANSACTION)) && !command.getFunctionName().contains("executeBatch")) {
                        int looperation = this.dispatchConnection.retrytimes;
                        if (looperation <= 0) {
                            this.dispatchConnection.close();
                            StringBuffer msg = new StringBuffer();
                            msg.append(e.getMessage() + "\n");
                            msg.append(this.getMonitorExceptionMessage());
                            throw new SQLException(msg.toString(), e.getSQLState(), e);
                        }
                        int interval = this.dispatchConnection.retryinterval;
                        while (looperation-- > 0) {
                            try {
                                if (this.dispatchConnection.isClosed()) {
                                    this.reconnect();
                                    if (this.dispatchConnection.getMainConn() == null) {
                                        if (KBLOGGER.isLoggable(Level.WARNING)) {
                                            KBLOGGER.log(Level.WARNING, "Connect Main _error retry _connect:" + looperation + "\n", new Object[0]);
                                        }
                                        Thread.sleep(interval * 1000);
                                        continue;
                                    }
                                }
                                this.cleanStatement();
                                st = this.getMainStatement();
                                if (this.record_main_stm != null) {
                                    this.resetStmtInfo(st, this.record_main_stm);
                                }
                                if (KBLOGGER.isLoggable(Level.WARNING)) {
                                    debugmsg = String.format("Send to all stmt,send to master session: (session={%s} url={%s} st={%s} _sqlType={%s})", this.dispatchConnection, ((KbConnection)st.getConnection()).getURL(), st, this._sqlType);
                                    KBLOGGER.log(Level.WARNING, debugmsg, new Object[0]);
                                }
                                this.accumulate(st);
                                r = command.execute(st);
                                this.currentDispatchType = 0;
                                this.dispatchType = 0;
                            }
                            catch (SQLException ei) {
                                if (!this.expectionHandler(ei, null, null)) {
                                    throw ei;
                                }
                                if (KBLOGGER.isLoggable(Level.WARNING)) {
                                    debugmsg = String.format("Send to AllStatement SQLException: (ei.getSQLState={%s},ei.getMessage={%s})", ei.getSQLState(), ei.getMessage());
                                    KBLOGGER.log(Level.WARNING, debugmsg, new Object[0]);
                                }
                                if (looperation > 0) {
                                    try {
                                        Thread.sleep(interval * 1000);
                                    }
                                    catch (InterruptedException e1) {
                                        if (!Thread.interrupted()) continue;
                                        KBLOGGER.log(Level.SEVERE, e1);
                                    }
                                    continue;
                                }
                                debugmsg = String.format("Send to AllStatement retry maxtimes still SQLException.\nCurrent business exception: %s", ei.getMessage());
                                String msg = this.constructExceptionMessage(debugmsg, e);
                                this.dispatchConnection.close();
                                ei.addSuppressed(e);
                                if (KBLOGGER.isLoggable(Level.WARNING)) {
                                    KBLOGGER.log(Level.WARNING, msg, new Object[0]);
                                    KBLOGGER.log(Level.WARNING, ei.getMessage(), new Object[0]);
                                }
                                throw new SQLException(msg, ei.getSQLState(), ei);
                            }
                            catch (InterruptedException e1) {
                                if (!Thread.interrupted()) continue;
                                KBLOGGER.log(Level.SEVERE, e1);
                            }
                        }
                    }
                    if (this.expectionHandler(e, null, null)) {
                        this.dispatchConnection.close();
                    }
                    if (KBLOGGER.isLoggable(Level.WARNING)) {
                        debugmsg = String.format("failare execute in all main and slave SQLException: (e.getSQLState={%s},e.getMessage={%s})", e.getSQLState(), e.getMessage());
                        KBLOGGER.log(Level.WARNING, debugmsg, new Object[0]);
                    }
                    throw e;
                }
                for (int i = 1; list != null && i < list.size() - 1; ++i) {
                    list.get(i).close();
                }
                break;
            }
            case 3: {
                List<java.sql.Statement> lis = this.getAllCurrentStatement();
                if (KBLOGGER.isLoggable(Level.INFO)) {
                    _sql.append(", send to current:");
                    for (java.sql.Statement t : lis) {
                        _sql.append("session : ").append(this.dispatchConnection).append(" , url:").append(((KbConnection)t.getConnection()).getURL() + " st" + st).append(" , ");
                    }
                    debugmsg = String.format("Send to current session: (_sql={%s},_sqlType={%s})", _sql.toString(), this._sqlType);
                    KBLOGGER.log(Level.INFO, debugmsg, new Object[0]);
                }
                block40: for (java.sql.Statement t : lis) {
                    try {
                        r = command.execute(t);
                    }
                    catch (SQLException e) {
                        if (this.expectionHandler(e, null, null) && (this._sqlType.equals("NULL") || !this._sqlType.equalsIgnoreCase(TYPE_INTRANSACTION)) && !command.getFunctionName().contains("executeBatch")) {
                            int looperation = this.dispatchConnection.retrytimes;
                            if (looperation <= 0) {
                                this.dispatchConnection.close();
                                throw e;
                            }
                            int interval = this.dispatchConnection.retryinterval;
                            while (looperation-- > 0) {
                                try {
                                    if (this.dispatchConnection.isClosed()) {
                                        this.reconnect();
                                        if (this.dispatchConnection.getMainConn() == null) {
                                            if (KBLOGGER.isLoggable(Level.WARNING)) {
                                                KBLOGGER.log(Level.WARNING, "Connect Main _error retry _connect:" + looperation + "\n", new Object[0]);
                                            }
                                            Thread.sleep(interval * 1000);
                                            continue;
                                        }
                                    }
                                    this.cleanStatement();
                                    st = this.getMainStatement();
                                    if (this.record_main_stm != null) {
                                        this.resetStmtInfo(st, this.record_main_stm);
                                    }
                                    if (KBLOGGER.isLoggable(Level.WARNING)) {
                                        debugmsg = String.format("Send to current stmt,send to master session: (session={%s} url={%s} st={%s} _sqlType={%s})", this.dispatchConnection, ((KbConnection)st.getConnection()).getURL(), st, this._sqlType);
                                        KBLOGGER.log(Level.WARNING, debugmsg, new Object[0]);
                                    }
                                    r = command.execute(st);
                                    this.currentDispatchType = 0;
                                    this.dispatchType = 0;
                                    continue block40;
                                }
                                catch (SQLException ei) {
                                    if (!this.expectionHandler(ei, null, null)) {
                                        throw ei;
                                    }
                                    if (KBLOGGER.isLoggable(Level.WARNING)) {
                                        debugmsg = String.format("Send to current SQLException: (ei.getSQLState={%s},ei.getMessage={%s})", ei.getSQLState(), ei.getMessage());
                                        KBLOGGER.log(Level.WARNING, debugmsg, new Object[0]);
                                    }
                                    if (looperation > 0) {
                                        try {
                                            Thread.sleep(interval * 1000);
                                        }
                                        catch (InterruptedException e1) {
                                            if (!Thread.interrupted()) continue;
                                            KBLOGGER.log(Level.SEVERE, e1);
                                        }
                                        continue;
                                    }
                                    debugmsg = String.format("Send to current retry failare maxtimes still SQLException.\nCurrent business exception: %s", ei.getMessage());
                                    String msg = this.constructExceptionMessage(debugmsg, e);
                                    this.dispatchConnection.close();
                                    ei.addSuppressed(e);
                                    if (KBLOGGER.isLoggable(Level.WARNING)) {
                                        KBLOGGER.log(Level.WARNING, msg, new Object[0]);
                                        KBLOGGER.log(Level.WARNING, ei.getMessage(), new Object[0]);
                                    }
                                    throw new SQLException(msg, ei.getSQLState(), ei);
                                }
                                catch (InterruptedException e1) {
                                    if (!Thread.interrupted()) continue;
                                    KBLOGGER.log(Level.SEVERE, e1);
                                }
                            }
                            continue;
                        }
                        if (this.expectionHandler(e, null, null)) {
                            this.dispatchConnection.close();
                        }
                        if (KBLOGGER.isLoggable(Level.WARNING)) {
                            debugmsg = String.format("failare execute in current stmt SQLException: (e.getSQLState={%s},e.getMessage={%s})", e.getSQLState(), e.getMessage());
                            KBLOGGER.log(Level.WARNING, debugmsg, new Object[0]);
                        }
                        throw e;
                    }
                }
                break;
            }
        }
        if (command.isExecuteFunction()) {
            AtomicLong t2 = new AtomicLong(System.currentTimeMillis() - t1.get());
            if (KBLOGGER.isLoggable(Level.INFO)) {
                if (st instanceof PreparedStatement) {
                    debugmsg = dispatchType == 0 ? String.format("url=[%s] BackendPID=[%s] _sql=[%s] master consume time:::[%s](ms)", ((KbConnection)st.getConnection()).getURL(), ((KbConnection)st.getConnection()).getBackendPID(), command.getFunctionName().substring(0, command.getFunctionName().length() - 1) + st + ")", t2.get()) : (dispatchType == 1 ? String.format("url=[%s] BackendPID=[%s] _sql=[%s] slave consume time:::[%s](ms)", ((KbConnection)st.getConnection()).getURL(), ((KbConnection)st.getConnection()).getBackendPID(), command.getFunctionName().substring(0, command.getFunctionName().length() - 1) + st + ")", t2.get()) : (dispatchType == 2 ? String.format("url=[%s] _sql=[%s] all consume time:::[%s](ms)", ((KbConnection)st.getConnection()).getURL(), command.getFunctionName().substring(0, command.getFunctionName().length() - 1) + st + ")", t2.get()) : String.format("url=[%s] _sql=[%s] current consume time:::[%s](ms)", ((KbConnection)st.getConnection()).getURL(), command.getFunctionName().substring(0, command.getFunctionName().length() - 1) + st + ")", t2.get())));
                    KBLOGGER.log(Level.INFO, debugmsg, new Object[0]);
                } else if (st != null) {
                    debugmsg = dispatchType == 0 ? String.format("url=[%s] BackendPID=[%s] _sql=[%s] master consume time:::[%s](ms)", ((KbConnection)st.getConnection()).getURL(), ((KbConnection)st.getConnection()).getBackendPID(), command.getFunctionName(), t2.get()) : (dispatchType == 1 ? String.format("url=[%s] BackendPID=[%s] _sql=[%s] slave consume time:::[%s](ms)", ((KbConnection)st.getConnection()).getURL(), ((KbConnection)st.getConnection()).getBackendPID(), command.getFunctionName(), t2.get()) : (dispatchType == 2 ? String.format("url=[%s] _sql=[%s] all consume time:::[%s](ms)", ((KbConnection)st.getConnection()).getURL(), command.getFunctionName(), t2.get()) : String.format("url=[%s] _sql=[%s] current consume time:::[%s](ms)", ((KbConnection)st.getConnection()).getURL(), command.getFunctionName(), t2.get())));
                    KBLOGGER.log(Level.INFO, debugmsg, new Object[0]);
                }
            }
            this.dispatchConnection.setLastSqlType(this._sqlType);
        }
        return r;
    }

    private String constructExceptionMessage(String message, SQLException e) {
        StringBuffer msg = new StringBuffer();
        msg.append(message + "\n");
        Throwable ex = e;
        while (ex.getCause() != null) {
            ex = ex.getCause();
        }
        msg.append(this.getMonitorExceptionMessage());
        msg.append("Suppressed first exception caused by: " + ex.toString() + "\n");
        if (ex.getSuppressed() != null) {
            for (Throwable ei : ex.getSuppressed()) {
                msg.append("The environment of the first exception occurred: " + ei.getMessage() + "\n");
            }
        }
        return msg.toString();
    }

    private String getMonitorExceptionMessage() {
        StringBuffer msg;
        block4: {
            block3: {
                msg = new StringBuffer();
                if (this.dispatchConnection.pCMV2.getSqlException() == null) break block3;
                msg.append("Current monitor exceptions: " + this.dispatchConnection.pCMV2.getSqlException() + "\n");
                Throwable es = this.dispatchConnection.pCMV2.getSqlException();
                while (es.getCause() != null) {
                    msg.append("Caused by: " + es.toString() + "\n");
                    es = es.getCause();
                }
                for (SQLException sqlException = this.dispatchConnection.pCMV2.getSqlException().getNextException(); sqlException != null; sqlException = sqlException.getNextException()) {
                    msg.append("   " + sqlException + "\n");
                }
                break block4;
            }
            if (this.dispatchConnection.pCMV2.getException() == null) break block4;
            msg.append("Current monitor exceptions: " + this.dispatchConnection.pCMV2.getException() + "\n");
            Throwable ee = this.dispatchConnection.pCMV2.getException();
            while (ee.getCause() != null) {
                msg.append("Caused by: " + ee.toString() + "\n");
                ee = ee.getCause();
            }
        }
        return msg.toString();
    }

    protected boolean getErrorCode(SQLException e) {
        boolean _flag = false;
        if (e.getSQLState() == null) {
            _flag = true;
            return _flag;
        }
        if (KSQLState.isConnectionError(e.getSQLState()) || e.getSQLState().equals("57P01") || e.getSQLState().equals("57P02") || e.getSQLState().equals("57P03")) {
            if (KBLOGGER.isLoggable(Level.INFO)) {
                KBLOGGER.log(Level.INFO, "getErrorCode: (SQLState={0},Message={1})", e.getSQLState(), e.getMessage());
            }
            _flag = true;
        }
        return _flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer changeExecuteType() throws KSQLException {
        int _result = 1;
        if (KBProperty.LOADBALANCE_STRATEGY.getInt(this.dispatchConnection.m_pros) != 1 && KBProperty.LOADBALANCE_STRATEGY.getInt(this.dispatchConnection.m_pros) != 2) {
            return _result;
        }
        String rate = KBProperty.HOSTLOADRATE.get(this.dispatchConnection.m_pros);
        if (Integer.valueOf(rate) > 0) {
            ConcurrentHashMap<String, AtomicInteger> concurrentHashMap = this.dispatchConnection.pCMV2.totalA_count;
            synchronized (concurrentHashMap) {
                BigDecimal _hostRate;
                String url = this.dispatchConnection.countUrl;
                if (this.dispatchConnection.pCMV2.totalA_count.get(url).get() == Integer.MAX_VALUE) {
                    _hostRate = new BigDecimal(this.dispatchConnection.pCMV2._hostA_count.get(url).get()).divide(new BigDecimal(this.dispatchConnection.pCMV2.totalA_count.get(url).get()), 2, 1);
                    this.dispatchConnection.pCMV2.totalA_count.get(url).set(100);
                    this.dispatchConnection.pCMV2._hostA_count.get(url).set(_hostRate.multiply(new BigDecimal(100)).intValue());
                }
                this.dispatchConnection.pCMV2.totalA_count.get(url).incrementAndGet();
                if (this.dispatchConnection.pCMV2._hostA_count.get(url).get() > 0) {
                    _hostRate = new BigDecimal(this.dispatchConnection.pCMV2._hostA_count.get(url).get()).divide(new BigDecimal(this.dispatchConnection.pCMV2.totalA_count.get(url).get()), 2, 1);
                    if (_hostRate.multiply(new BigDecimal(100)).compareTo(new BigDecimal(rate)) == -1) {
                        _result = 0;
                        this.dispatchConnection.pCMV2._hostA_count.get(url).incrementAndGet();
                    }
                } else {
                    _result = 0;
                    this.dispatchConnection.pCMV2._hostA_count.get(url).incrementAndGet();
                }
            }
        }
        return _result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(int _count) throws KSQLException {
        if (KBProperty.LOADBALANCE_STRATEGY.getInt(this.dispatchConnection.m_pros) != 1 && KBProperty.LOADBALANCE_STRATEGY.getInt(this.dispatchConnection.m_pros) != 2) {
            return;
        }
        if (KBProperty.HOSTLOADRATE.getIntNoCheck(this.dispatchConnection.m_pros) > 0) {
            ConcurrentHashMap<String, AtomicInteger> concurrentHashMap = this.dispatchConnection.pCMV2.totalA_count;
            synchronized (concurrentHashMap) {
                String url = this.dispatchConnection.countUrl;
                if (this.dispatchConnection.pCMV2.totalA_count.get(url).get() + _count > Integer.MAX_VALUE) {
                    BigDecimal _hostRate = new BigDecimal(this.dispatchConnection.pCMV2._hostA_count.get(url).get()).divide(new BigDecimal(this.dispatchConnection.pCMV2.totalA_count.get(url).get()), 2, 1);
                    this.dispatchConnection.pCMV2.totalA_count.get(url).set(100);
                    this.dispatchConnection.pCMV2._hostA_count.get(url).set(_hostRate.multiply(new BigDecimal(100)).intValue());
                }
                this.dispatchConnection.pCMV2.totalA_count.get(url).addAndGet(_count);
                this.dispatchConnection.pCMV2._hostA_count.get(url).incrementAndGet();
            }
        }
    }

    protected StatementCreateCommand<? extends java.sql.Statement> getCommand() {
        return this.createCommand;
    }

    protected abstract boolean expectionHandler(SQLException var1, java.sql.Statement var2, java.sql.Statement var3) throws SQLException;

    public void resetStatement(java.sql.Statement st) throws SQLException {
        st.setMaxFieldSize(this.maxFieldSize);
        st.setMaxRows(this.maxRows);
        st.setEscapeProcessing(this.escapeProcessing);
        st.setQueryTimeout(this.queryTimeout);
        st.setCursorName(this.cursorName);
        st.setFetchDirection(this.fetchDirection);
        if (this.fetchSizeModify) {
            st.setFetchSize(this.fetchSize);
        }
        st.setPoolable(this.poolable);
        if (this.closeOnCompletion) {
            ((KbStatement)st).closeOnCompletion();
        }
    }

    protected static interface ExecuteCommand<R> {
        public boolean isExecuteFunction();

        public String getFunctionName();

        public R execute(java.sql.Statement var1) throws SQLException;
    }
}

