/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.jdbc;

import com.kingbase8.util.GT;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import com.kingbase8.util.TraceLogger;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;

public final class KBEscapedFunctions2 {
    private static final int INT0 = 0;
    private static final String SQL_TSI_MINUTE_STR = "SQL_TSI_MINUTE";
    private static final ConcurrentMap<String, Method> FUNCTION_MAP_T = KBEscapedFunctions2.createFunctionMap_("_sql");
    private static final String SQL_TSI_YEAR_STR = "SQL_TSI_YEAR";
    private static final String SQL_TSI_ROOT_STR = "SQL_TSI_";
    private static final int INT1 = 1;
    private static final String SQL_TSI_WEEK_STR = "SQL_TSI_WEEK";
    private static final String SQL_TSI_MONTH_STR = "SQL_TSI_MONTH";
    private static final int INT3 = 3;
    private static final String SQL_TSI_DAY_STR = "SQL_TSI_DAY";
    private static final String SQL_TSI_SECOND_STR = "SQL_TSI_SECOND";
    private static final String SQL_TSI_HOUR_STR = "SQL_TSI_HOUR";
    private static final String SQL_TSI_FRAC_SECOND_STR = "SQL_TSI_FRAC_SECOND";
    private static final String SQL_TSI_QUARTER_STR = "SQL_TSI_QUARTER";

    public static void appendCall(StringBuilder stringBuilder, String beginStr, String separatorStr, String endStr, List<? extends CharSequence> argsList) {
        int i;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int length = beginStr.length();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int numberOfArguments = argsList.size();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        for (i = 0; i < numberOfArguments; ++i) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            length += argsList.get(i).length();
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        stringBuilder.ensureCapacity(stringBuilder.length() + (length += separatorStr.length() * (numberOfArguments - 1)) + 1);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        stringBuilder.append(beginStr);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        for (i = 0; i < numberOfArguments; ++i) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (i > 0) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                stringBuilder.append(separatorStr);
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            stringBuilder.append(argsList.get(i));
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        stringBuilder.append(endStr);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public static Method getFunction(String functionName) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Method mtd = (Method)FUNCTION_MAP_T.get(functionName);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (mtd != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return mtd;
        }
        String nameLower = functionName.toLowerCase(Locale.US);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (nameLower.equals(functionName)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return null;
        }
        mtd = (Method)FUNCTION_MAP_T.get(nameLower);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (mtd != null && FUNCTION_MAP_T.size() < 1000) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            FUNCTION_MAP_T.putIfAbsent(functionName, mtd);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return mtd;
    }

    private static ConcurrentMap<String, Method> createFunctionMap_(String prefix) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Method[] mtds = KBEscapedFunctions2.class.getMethods();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int initialCapacity = mtds.length * 2;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        ConcurrentHashMap<String, Method> funcMap = new ConcurrentHashMap<String, Method>(initialCapacity);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        for (Method mtd : mtds) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (mtd.getName().startsWith(prefix)) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                funcMap.put(mtd.getName().substring(prefix.length()).toLowerCase(Locale.US), mtd);
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return funcMap;
    }

    public static void _sqllog(StringBuilder _buf, List<? extends CharSequence> parsedArgs) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBEscapedFunctions2.singleArgumentFunctionCall(_buf, "ln(", "log", parsedArgs);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public static void _sqllog10(StringBuilder _buf, List<? extends CharSequence> parsedArgs) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBEscapedFunctions2.singleArgumentFunctionCall(_buf, "log(", "log10", parsedArgs);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public static void _sqlceiling(StringBuilder _buf, List<? extends CharSequence> parsedArgs) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBEscapedFunctions2.singleArgumentFunctionCall(_buf, "ceil(", "ceiling", parsedArgs);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public static void _sqltruncate(StringBuilder _buf, List<? extends CharSequence> parsedArgs) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBEscapedFunctions2.twoArgumentsFunctionCall(_buf, "trunc(", "truncate", parsedArgs);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public static void _sqlchar(StringBuilder _buf, List<? extends CharSequence> parsedArgs) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBEscapedFunctions2.singleArgumentFunctionCall(_buf, "chr(", "char", parsedArgs);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public static void _sqlconcat(StringBuilder _buf, List<? extends CharSequence> parsedArgs) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBEscapedFunctions2.appendCall(_buf, "(", "||", ")", parsedArgs);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public static void _sqlinsert(StringBuilder _buf, List<? extends CharSequence> parsedArgs) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (parsedArgs.size() != 4) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("{0} function takes four and only four argument.", "insert"), KSQLState.SYNTAX_ERROR);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        _buf.append("overlay(");
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        _buf.append(parsedArgs.get(0)).append(" placing ").append(parsedArgs.get(3));
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        _buf.append(" from ").append(parsedArgs.get(1)).append(" for ").append(parsedArgs.get(2));
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        _buf.append(')');
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public static void _sqlpower(StringBuilder _buf, List<? extends CharSequence> parsedArgs) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBEscapedFunctions2.twoArgumentsFunctionCall(_buf, "pow(", "power", parsedArgs);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public static void _sqlleft(StringBuilder _buf, List<? extends CharSequence> parsedArgs) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (parsedArgs.size() != 2) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("{0} function takes two and only two arguments.", "left"), KSQLState.SYNTAX_ERROR);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBEscapedFunctions2.appendCall(_buf, "substring(", " for ", ")", parsedArgs);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public static void _sqllength(StringBuilder _buf, List<? extends CharSequence> parsedArgs) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (parsedArgs.size() != 1) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("{0} function takes one and only one argument.", "length"), KSQLState.SYNTAX_ERROR);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBEscapedFunctions2.appendCall(_buf, "length(trim(trailing from ", "", "))", parsedArgs);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public static void _sqllcase(StringBuilder _buf, List<? extends CharSequence> parsedArgs) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBEscapedFunctions2.singleArgumentFunctionCall(_buf, "lower(", "lcase", parsedArgs);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public static void _sqlltrim(StringBuilder _buf, List<? extends CharSequence> parsedArgs) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBEscapedFunctions2.singleArgumentFunctionCall(_buf, "trim(leading from ", "ltrim", parsedArgs);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public static void _sqlright(StringBuilder stringBuilder, List<? extends CharSequence> parsedArgsT) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (parsedArgsT.size() != 2) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("{0} function takes two and only two arguments.", "right"), KSQLState.SYNTAX_ERROR);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        stringBuilder.append("substring(");
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        stringBuilder.append(parsedArgsT.get(0)).append(" from (length(").append(parsedArgsT.get(0)).append(")+1-").append(parsedArgsT.get(1));
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        stringBuilder.append("))");
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public static void _sqlrtrim(StringBuilder _buf, List<? extends CharSequence> parsedArgs) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBEscapedFunctions2.singleArgumentFunctionCall(_buf, "trim(trailing from ", "rtrim", parsedArgs);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public static void _sqllocate(StringBuilder stringBuilder, List<? extends CharSequence> parsedArgsList) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (parsedArgsList.size() == 2) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            KBEscapedFunctions2.appendCall(stringBuilder, "position(", " in ", ")", parsedArgsList);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        } else if (parsedArgsList.size() == 3) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String str = "position(" + parsedArgsList.get(0) + " in substring(" + parsedArgsList.get(1) + " from " + parsedArgsList.get(2) + "))";
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            stringBuilder.append("(").append(parsedArgsList.get(2)).append("*sign(").append(str).append(")+").append(str).append(")");
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("{0} function takes two or three arguments.", "locate"), KSQLState.SYNTAX_ERROR);
        }
    }

    public static void _sqlsubstring(StringBuilder _buf, List<? extends CharSequence> parsedArgs) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int argSize = parsedArgs.size();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (argSize != 2 && argSize != 3) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("{0} function takes two or three arguments.", "substring"), KSQLState.SYNTAX_ERROR);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBEscapedFunctions2.appendCall(_buf, "substr(", ",", ")", parsedArgs);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public static void _sqlucase(StringBuilder _buf, List<? extends CharSequence> parsedArgs) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBEscapedFunctions2.singleArgumentFunctionCall(_buf, "upper(", "ucase", parsedArgs);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public static void _sqlspace(StringBuilder _buf, List<? extends CharSequence> parsedArgs) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBEscapedFunctions2.singleArgumentFunctionCall(_buf, "repeat(' ',", "space", parsedArgs);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public static void _sqlcurtime(StringBuilder _buf, List<? extends CharSequence> parsedArgs) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBEscapedFunctions2.zeroArgumentFunctionCall(_buf, "current_time", "curtime", parsedArgs);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public static void _sqlcurdate(StringBuilder _buf, List<? extends CharSequence> parsedArgs) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBEscapedFunctions2.zeroArgumentFunctionCall(_buf, "current_date", "curdate", parsedArgs);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public static void _sqldayofmonth(StringBuilder _buf, List<? extends CharSequence> parsedArgs) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBEscapedFunctions2.singleArgumentFunctionCall(_buf, "extract(day from ", "dayofmonth", parsedArgs);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public static void _sqldayofweek(StringBuilder _buf, List<? extends CharSequence> parsedArgs) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (parsedArgs.size() != 1) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("{0} function takes one and only one argument.", "dayofweek"), KSQLState.SYNTAX_ERROR);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBEscapedFunctions2.appendCall(_buf, "extract(dow from ", ",", ")+1", parsedArgs);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public static void _sqldayname(StringBuilder _buf, List<? extends CharSequence> parsedArgs) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (parsedArgs.size() != 1) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("{0} function takes one and only one argument.", "dayname"), KSQLState.SYNTAX_ERROR);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBEscapedFunctions2.appendCall(_buf, "to_char(", ",", ",'Day')", parsedArgs);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public static void _sqlhour(StringBuilder _buf, List<? extends CharSequence> parsedArgs) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBEscapedFunctions2.singleArgumentFunctionCall(_buf, "extract(hour from ", "hour", parsedArgs);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public static void _sqlminute(StringBuilder _buf, List<? extends CharSequence> parsedArgs) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBEscapedFunctions2.singleArgumentFunctionCall(_buf, "extract(minute from ", "minute", parsedArgs);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public static void _sqldayofyear(StringBuilder _buf, List<? extends CharSequence> parsedArgs) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBEscapedFunctions2.singleArgumentFunctionCall(_buf, "extract(doy from ", "dayofyear", parsedArgs);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public static void _sqlmonthname(StringBuilder _buf, List<? extends CharSequence> parsedArgs) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (parsedArgs.size() != 1) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("{0} function takes one and only one argument.", "monthname"), KSQLState.SYNTAX_ERROR);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBEscapedFunctions2.appendCall(_buf, "to_char(", ",", ",'Month')", parsedArgs);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public static void _sqlquarter(StringBuilder _buf, List<? extends CharSequence> parsedArgs) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBEscapedFunctions2.singleArgumentFunctionCall(_buf, "extract(quarter from ", "quarter", parsedArgs);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public static void _sqlmonth(StringBuilder _buf, List<? extends CharSequence> parsedArgs) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBEscapedFunctions2.singleArgumentFunctionCall(_buf, "extract(month from ", "month", parsedArgs);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public static void _sqlweek(StringBuilder _buf, List<? extends CharSequence> parsedArgs) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBEscapedFunctions2.singleArgumentFunctionCall(_buf, "extract(week from ", "week", parsedArgs);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public static void _sqlyear(StringBuilder _buf, List<? extends CharSequence> parsedArgs) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBEscapedFunctions2.singleArgumentFunctionCall(_buf, "extract(year from ", "year", parsedArgs);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public static void _sqlsecond(StringBuilder _buf, List<? extends CharSequence> parsedArgs) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBEscapedFunctions2.singleArgumentFunctionCall(_buf, "extract(second from ", "second", parsedArgs);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public static void _sqltimestampadd(StringBuilder _buf, List<? extends CharSequence> parsedArgs) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (parsedArgs.size() != 3) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("{0} function takes three and only three arguments.", "timestampadd"), KSQLState.SYNTAX_ERROR);
        }
        _buf.append('(');
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBEscapedFunctions2.appendInterval(_buf, parsedArgs.get(0).toString(), parsedArgs.get(1).toString());
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        _buf.append('+').append(parsedArgs.get(2)).append(')');
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    private static boolean appendSingleIntervalCastString(StringBuilder stringBuilder, String cmpStr, String typeStr, String valStr, String kbType) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (!KBEscapedFunctions2.isSameTsi_(typeStr, cmpStr)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return false;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        stringBuilder.ensureCapacity(stringBuilder.length() + 5 + 4 + 14 + valStr.length() + kbType.length());
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        stringBuilder.append("CAST(").append(valStr).append("||' ").append(kbType).append("' as interval)");
        return true;
    }

    private static void appendInterval(StringBuilder _buf, String type, String _value) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (!KBEscapedFunctions2.isTsi_(type)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("Interval {0} not yet implemented", type), KSQLState.SYNTAX_ERROR);
        }
        if (KBEscapedFunctions2.appendSingleIntervalCastString(_buf, SQL_TSI_DAY_STR, type, _value, "day") || KBEscapedFunctions2.appendSingleIntervalCastString(_buf, SQL_TSI_SECOND_STR, type, _value, "second") || KBEscapedFunctions2.appendSingleIntervalCastString(_buf, SQL_TSI_HOUR_STR, type, _value, "hour") || KBEscapedFunctions2.appendSingleIntervalCastString(_buf, SQL_TSI_MINUTE_STR, type, _value, "minute") || KBEscapedFunctions2.appendSingleIntervalCastString(_buf, SQL_TSI_MONTH_STR, type, _value, "month") || KBEscapedFunctions2.appendSingleIntervalCastString(_buf, SQL_TSI_WEEK_STR, type, _value, "week") || KBEscapedFunctions2.appendSingleIntervalCastString(_buf, SQL_TSI_YEAR_STR, type, _value, "year")) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return;
        }
        if (KBEscapedFunctions2.isSameTsi_(SQL_TSI_QUARTER_STR, type)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _buf.append("CAST((").append(_value).append("::int * 3) || ' month' as interval)");
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        throw new KSQLException(GT.tr("Interval {0} not yet implemented", type), KSQLState.NOT_IMPLEMENTED);
    }

    private static boolean isTsi_(String intervalStr) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return intervalStr.regionMatches(true, 0, SQL_TSI_ROOT_STR, 0, SQL_TSI_ROOT_STR.length());
    }

    private static boolean isSameTsi_(String aStr, String bStr) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        boolean b = aStr.length() == bStr.length();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        boolean b1 = bStr.length() > SQL_TSI_ROOT_STR.length();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int length = SQL_TSI_ROOT_STR.length();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int length1 = SQL_TSI_ROOT_STR.length();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int len = bStr.length() - SQL_TSI_ROOT_STR.length();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        boolean b2 = aStr.regionMatches(true, length, bStr, length1, len);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return b && b1 && b2;
    }

    private static String constantToDatePart(StringBuilder _buf, String type) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (!KBEscapedFunctions2.isTsi_(type)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("Interval {0} not yet implemented", type), KSQLState.SYNTAX_ERROR);
        }
        if (KBEscapedFunctions2.isSameTsi_(SQL_TSI_DAY_STR, type)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return "day";
        }
        if (KBEscapedFunctions2.isSameTsi_(SQL_TSI_SECOND_STR, type)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return "second";
        }
        if (KBEscapedFunctions2.isSameTsi_(SQL_TSI_HOUR_STR, type)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return "hour";
        }
        if (KBEscapedFunctions2.isSameTsi_(SQL_TSI_MINUTE_STR, type)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return "minute";
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        throw new KSQLException(GT.tr("Interval {0} not yet implemented", type), KSQLState.SYNTAX_ERROR);
    }

    public static void _sqldatabase(StringBuilder _buf, List<? extends CharSequence> parsedArgs) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBEscapedFunctions2.zeroArgumentFunctionCall(_buf, "current_database()", "database", parsedArgs);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public static void _sqltimestampdiff(StringBuilder stringBuilder, List<? extends CharSequence> parsedArgsT) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (parsedArgsT.size() != 3) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("{0} function takes three and only three arguments.", "timestampdiff"), KSQLState.SYNTAX_ERROR);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        stringBuilder.append("extract( ").append(KBEscapedFunctions2.constantToDatePart(stringBuilder, parsedArgsT.get(0).toString())).append(" from (").append(parsedArgsT.get(2)).append("-").append(parsedArgsT.get(1)).append("))");
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public static void _sqluser(StringBuilder _buf, List<? extends CharSequence> parsedArgs) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBEscapedFunctions2.zeroArgumentFunctionCall(_buf, "user", "user", parsedArgs);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    private static void zeroArgumentFunctionCall(StringBuilder _buf, String call, String functionName, List<? extends CharSequence> parsedArgs) throws KSQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (!parsedArgs.isEmpty()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("{0} function doesn''t take any argument.", functionName), KSQLState.SYNTAX_ERROR);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        _buf.append(call);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public static void _sqlifnull(StringBuilder _buf, List<? extends CharSequence> parsedArgs) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBEscapedFunctions2.twoArgumentsFunctionCall(_buf, "coalesce(", "ifnull", parsedArgs);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    private static void twoArgumentsFunctionCall(StringBuilder _buf, String call, String functionName, List<? extends CharSequence> parsedArgs) throws KSQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (parsedArgs.size() != 2) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("{0} function takes two and only two arguments.", functionName), KSQLState.SYNTAX_ERROR);
        }
        KBEscapedFunctions2.appendCall(_buf, call, ",", ")", parsedArgs);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    private static void singleArgumentFunctionCall(StringBuilder _buf, String call, String functionName, List<? extends CharSequence> parsedArgs) throws KSQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (parsedArgs.size() != 1) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("{0} function takes one and only one argument.", functionName), KSQLState.SYNTAX_ERROR);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        CharSequence arg0 = parsedArgs.get(0);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        _buf.ensureCapacity(_buf.length() + call.length() + arg0.length() + 1);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        _buf.append(call).append(arg0).append(')');
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }
}

