/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.jdbc;

import com.kingbase8.core.JavaVersion;
import com.kingbase8.core.Provider;
import com.kingbase8.jdbc.CompatibleDB;
import com.kingbase8.util.ByteConverter;
import com.kingbase8.util.GT;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import com.kingbase8.util.TraceLogger;
import java.lang.reflect.Field;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.chrono.IsoEra;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import java.util.logging.Level;

public class TimestampUtils {
    private static final int ONEDAY_T = 86400000;
    private static final char[] ZEROS_T;
    private static final int MAX_NANOS_BEFORE_WRAP_ON_ROUND_T = 999999500;
    private static final char[][] NUMBERS_T;
    private static final Map<String, TimeZone> ZONES_IN_GMT;
    private static final OffsetDateTime MAX_OFFSET_DATETIME_T;
    private static final LocalDate MIN_LOCAL_DATE_T;
    private static final Duration ONE_MICROSECOND_T;
    private static final LocalDateTime MIN_LOCAL_DATETIME_T;
    private static final LocalDateTime MAX_LOCAL_DATETIME_T;
    private static final LocalTime MAX_TIME_T;
    private static final OffsetDateTime MIN_OFFSET_DATETIME_T;
    private TimeZone prevDefaultZoneFieldVal_T;
    private static final Field DEFAULT_TIME_ZONE_FIELD_T;
    private static String compatibleLevel;
    private TimeZone defaultTimeZoneCache_T;
    private final Calendar calWithUserTz = new GregorianCalendar();
    private final StringBuilder s_buf = new StringBuilder();
    private Calendar calendarCache;
    private final TimeZone utcTimeZone = TimeZone.getTimeZone("UTC");
    private final boolean usesDouble;
    private int calendarCacheZone;
    private final Provider<TimeZone> tzProvider;

    TimestampUtils(boolean usesDouble, Provider<TimeZone> tzProvider, String compatibleLevel) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.usesDouble = usesDouble;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.tzProvider = tzProvider;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        TimestampUtils.compatibleLevel = compatibleLevel;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    private Calendar getCalendar(int sign, int hr, int min, int sec) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int rawOffset = sign * (((hr * 60 + min) * 60 + sec) * 1000);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.calendarCache != null && this.calendarCacheZone == rawOffset) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return this.calendarCache;
        }
        StringBuilder timeZoneID = new StringBuilder("GMT");
        timeZoneID.append(sign < 0 ? (char)'-' : '+');
        if (hr < 10) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            timeZoneID.append('0');
        }
        timeZoneID.append(hr);
        if (min < 10) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            timeZoneID.append('0');
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        timeZoneID.append(min);
        if (sec < 10) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            timeZoneID.append('0');
        }
        timeZoneID.append(sec);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        SimpleTimeZone syntheticTZ = new SimpleTimeZone(rawOffset, timeZoneID.toString());
        this.calendarCache = new GregorianCalendar(syntheticTZ);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.calendarCacheZone = rawOffset;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.calendarCache;
    }

    private ParsedTimestamp parseBackendTimestamp_(String strT) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        char[] sT = strT.toCharArray();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int slengT = sT.length;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        ParsedTimestamp resultT = new ParsedTimestamp();
        try {
            char sep_T;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int startT = TimestampUtils.skipWhitespace(sT, 0);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int endT = TimestampUtils.firstNonDigit(sT, startT);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (TimestampUtils.charAt(sT, endT) == '-') {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                resultT.hasDate = true;
                resultT.beginYear = TimestampUtils.number(sT, startT, endT);
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                startT = endT + 1;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                endT = TimestampUtils.firstNonDigit(sT, startT);
                resultT.beginMonth = TimestampUtils.number(sT, startT, endT);
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                sep_T = TimestampUtils.charAt(sT, endT);
                if (sep_T != '-') {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    throw new NumberFormatException("Expected date to be dash-separated, got '" + sep_T + "'");
                }
                startT = endT + 1;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                endT = TimestampUtils.firstNonDigit(sT, startT);
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                resultT.day = TimestampUtils.number(sT, startT, endT);
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                startT = TimestampUtils.skipWhitespace(sT, endT);
            }
            if (Character.isDigit(TimestampUtils.charAt(sT, startT))) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                resultT.hasTimeVal = true;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                endT = TimestampUtils.firstNonDigit(sT, startT);
                resultT.hour = TimestampUtils.number(sT, startT, endT);
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                sep_T = TimestampUtils.charAt(sT, endT);
                if (sep_T != ':') {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    throw new NumberFormatException("Expected time to be _colon-separated, got '" + sep_T + "'");
                }
                startT = endT + 1;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                endT = TimestampUtils.firstNonDigit(sT, startT);
                resultT.minute = TimestampUtils.number(sT, startT, endT);
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                sep_T = TimestampUtils.charAt(sT, endT);
                if (sep_T != ':') {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    throw new NumberFormatException("Expected time to be _colon-separated, got '" + sep_T + "'");
                }
                startT = endT + 1;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                endT = TimestampUtils.firstNonDigit(sT, startT);
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                resultT.second = TimestampUtils.number(sT, startT, endT);
                startT = endT;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (TimestampUtils.charAt(sT, startT) == '.') {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    endT = TimestampUtils.firstNonDigit(sT, startT + 1);
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    int numT = TimestampUtils.number(sT, startT + 1, endT);
                    for (int numlength = endT - (startT + 1); numlength < 9; ++numlength) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        numT *= 10;
                    }
                    resultT.nanos = numT;
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    startT = endT;
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                startT = TimestampUtils.skipWhitespace(sT, startT);
            }
            if ((sep_T = TimestampUtils.charAt(sT, startT)) == '-' || sep_T == '+') {
                int timezoneminT;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                int timezonesignT = sep_T == '-' ? -1 : 1;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                endT = TimestampUtils.firstNonDigit(sT, startT + 1);
                int timezonehrT = TimestampUtils.number(sT, startT + 1, endT);
                startT = endT;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                sep_T = TimestampUtils.charAt(sT, startT);
                if (sep_T == ':') {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    endT = TimestampUtils.firstNonDigit(sT, startT + 1);
                    timezoneminT = TimestampUtils.number(sT, startT + 1, endT);
                    startT = endT;
                } else {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    timezoneminT = 0;
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                int timezonesecT = 0;
                sep_T = TimestampUtils.charAt(sT, startT);
                if (sep_T == ':') {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    endT = TimestampUtils.firstNonDigit(sT, startT + 1);
                    timezonesecT = TimestampUtils.number(sT, startT + 1, endT);
                    startT = endT;
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                resultT.timezone = this.getCalendar(timezonesignT, timezonehrT, timezoneminT, timezonesecT);
                startT = TimestampUtils.skipWhitespace(sT, startT);
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (resultT.hasDate && startT < slengT) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                String eraString = new String(sT, startT, slengT - startT);
                if (eraString.startsWith("AD")) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    resultT.era = 1;
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    startT += 2;
                } else if (eraString.startsWith("BC")) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    resultT.era = 0;
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    startT += 2;
                }
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (startT < slengT) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                throw new NumberFormatException("Trailing junk on timestamp: '" + new String(sT, startT, slengT - startT) + "'");
            }
            if (!resultT.hasTimeVal && !resultT.hasDate) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                throw new NumberFormatException("Timestamp has neither date nor time");
            }
        }
        catch (NumberFormatException numberFormatException) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String info = "Bad _value for type timestamp/date/time: {1}";
            throw new KSQLException(GT.tr("Bad _value for type timestamp/date/time: {1}", strT), KSQLState.BAD_DATETIME_FORMAT, (Throwable)numberFormatException);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return resultT;
    }

    public synchronized Timestamp toTimestamp(Calendar calendar, String s) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (s == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return null;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int sleng = s.length();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (sleng == 8 && s.equals("infinity")) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return new Timestamp(9223372036825200000L);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (sleng == 9 && s.equals("-infinity")) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return new Timestamp(-9223372036832400000L);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        ParsedTimestamp timestamp = this.parseBackendTimestamp_(s);
        Calendar useCalendarT = timestamp.timezone != null ? timestamp.timezone : this.setupCalendar(calendar);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        useCalendarT.set(13, timestamp.second);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        useCalendarT.set(1, timestamp.beginYear);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        useCalendarT.set(5, timestamp.day);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        useCalendarT.set(12, timestamp.minute);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        useCalendarT.set(11, timestamp.hour);
        useCalendarT.set(2, timestamp.beginMonth - 1);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        useCalendarT.set(14, 0);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        useCalendarT.set(0, timestamp.era);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Timestamp _result = new Timestamp(useCalendarT.getTimeInMillis());
        _result.setNanos(timestamp.nanos);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return _result;
    }

    public LocalTime toLocalTime(String str) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (str == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return null;
        }
        if (str.equals("24:00:00")) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return LocalTime.MAX;
        }
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            LocalTime parse = LocalTime.parse(str);
            return parse;
        }
        catch (DateTimeParseException dateTimeParseException) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String info = "Bad _value for type timestamp/date/time: {1}";
            throw new KSQLException(GT.tr("Bad _value for type timestamp/date/time: {1}", str), KSQLState.BAD_DATETIME_FORMAT, (Throwable)dateTimeParseException);
        }
    }

    public LocalDateTime toLocalDateTime(String str) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (str == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return null;
        }
        int sleng = str.length();
        if (sleng == 8 && str.equals("infinity")) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return LocalDateTime.MAX;
        }
        if (sleng == 9 && str.equals("-infinity")) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return LocalDateTime.MIN;
        }
        ParsedTimestamp timestamp = this.parseBackendTimestamp_(str);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        LocalDateTime _result = LocalDateTime.of(timestamp.beginYear, timestamp.beginMonth, timestamp.day, timestamp.hour, timestamp.minute, timestamp.second, timestamp.nanos);
        if (timestamp.era == 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            LocalDateTime localDateTime = _result.with(ChronoField.ERA, IsoEra.BCE.getValue());
            return localDateTime;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return _result;
    }

    public OffsetDateTime toOffsetDateTime(String str) throws SQLException {
        int _offsetSeconds;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (str == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return null;
        }
        int sleng = str.length();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (sleng == 8 && str.equals("infinity")) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return OffsetDateTime.MAX;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (sleng == 9 && str.equals("-infinity")) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return OffsetDateTime.MIN;
        }
        ParsedTimestamp timestamp = this.parseBackendTimestamp_(str);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Calendar timezone = timestamp.timezone;
        if (timezone == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _offsetSeconds = 0;
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _offsetSeconds = timezone.get(15) / 1000;
        }
        ZoneOffset zoneOffset = ZoneOffset.ofTotalSeconds(_offsetSeconds);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        OffsetDateTime _result = OffsetDateTime.of(timestamp.beginYear, timestamp.beginMonth, timestamp.day, timestamp.hour, timestamp.minute, timestamp.second, timestamp.nanos, zoneOffset).withOffsetSameInstant(ZoneOffset.UTC);
        if (timestamp.era == 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            OffsetDateTime offsetDateTime = _result.with(ChronoField.ERA, IsoEra.BCE.getValue());
            return offsetDateTime;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return _result;
    }

    public OffsetDateTime toOffsetDateTime(Time time) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        LocalTime localTime = time.toLocalTime();
        LocalDateTime localDateTime = localTime.atDate(LocalDate.of(1970, 1, 1));
        return localDateTime.atOffset(ZoneOffset.UTC);
    }

    public OffsetDateTime toOffsetDateTimeBin(byte[] _bytes) throws KSQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        ParsedBinaryTimestampT parsedtimestamp = this.toProlepticParsedTimestampBin(_bytes);
        if (parsedtimestamp.infinity == EInfinity.POSITIVE) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return OffsetDateTime.MAX;
        }
        if (parsedtimestamp.infinity == EInfinity.NEGATIVE) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return OffsetDateTime.MIN;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Instant instant = Instant.ofEpochSecond(parsedtimestamp.milliseconds / 1000L, parsedtimestamp.nanos);
        OffsetDateTime offsetDateTime = OffsetDateTime.ofInstant(instant, ZoneOffset.UTC);
        return offsetDateTime;
    }

    public synchronized Time toTime(Calendar calendar, String s) throws SQLException {
        Calendar useCalendarT;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (s == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return null;
        }
        ParsedTimestamp timestamp = this.parseBackendTimestamp_(s);
        Calendar calendar2 = useCalendarT = timestamp.timezone != null ? timestamp.timezone : this.setupCalendar(calendar);
        if (timestamp.timezone == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            useCalendarT.set(5, timestamp.day);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            useCalendarT.set(2, timestamp.beginMonth - 1);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            useCalendarT.set(0, timestamp.era);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            useCalendarT.set(1, timestamp.beginYear);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            useCalendarT.set(5, 1);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            useCalendarT.set(2, 0);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            useCalendarT.set(0, 1);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            useCalendarT.set(1, 1970);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        useCalendarT.set(14, 0);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        useCalendarT.set(12, timestamp.minute);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        useCalendarT.set(13, timestamp.second);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        useCalendarT.set(11, timestamp.hour);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        long timeMillis = useCalendarT.getTimeInMillis() + (long)(timestamp.nanos / 1000000);
        if (timestamp.timezone != null || timestamp.beginYear == 1970 && timestamp.era == 1) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            Time time = new Time(timeMillis);
            return time;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Time time = this.convertToTime(timeMillis, useCalendarT.getTimeZone());
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return time;
    }

    public synchronized Date toDate(Calendar calendar, String s) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Timestamp timestamp = this.toTimestamp(calendar, s);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (timestamp == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return null;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Date convertToDate = this.convertToDate(timestamp.getTime(), calendar == null ? null : calendar.getTimeZone());
        return convertToDate;
    }

    private Calendar setupCalendar(Calendar calendar) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        TimeZone tz = calendar == null ? null : calendar.getTimeZone();
        Calendar sharedCalendar = this.getSharedCalendar(tz);
        return sharedCalendar;
    }

    public Calendar getSharedCalendar(TimeZone tz) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (tz == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            tz = this.getDefaultTz_();
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Calendar tmp = this.calWithUserTz;
        tmp.setTimeZone(tz);
        return tmp;
    }

    private static boolean nanosExceed499(int nanosT) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        boolean b = nanosT % 1000 > 499;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return b;
    }

    public synchronized String toString(Calendar calendar, Timestamp x) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String s = this.toString(calendar, x, true);
        return s;
    }

    public synchronized String toString(Calendar calendarT, Timestamp timestamp, boolean withTimeZoneT) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (timestamp.getTime() == 9223372036825200000L) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return "infinity";
        }
        if (timestamp.getTime() == -9223372036832400000L) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return "-infinity";
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        calendarT = this.setupCalendar(calendarT);
        long timeMillis = timestamp.getTime();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int nanosT = timestamp.getNanos();
        if (nanosT >= 999999500) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            nanosT = 0;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            ++timeMillis;
        } else if (TimestampUtils.nanosExceed499(nanosT)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            nanosT += 1000 - nanosT % 1000;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        calendarT.setTimeInMillis(timeMillis);
        this.s_buf.setLength(0);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        TimestampUtils.appendDate(this.s_buf, calendarT);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.s_buf.append(' ');
        TimestampUtils.appendTime(this.s_buf, calendarT, nanosT);
        if (withTimeZoneT) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.appendTimeZone(this.s_buf, calendarT);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        TimestampUtils.appendEra(this.s_buf, calendarT);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.s_buf.toString();
    }

    public synchronized String toString(Calendar calendarT, Date date) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String s = this.toString(calendarT, date, true);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return s;
    }

    public synchronized String toString(Calendar calendarT, Date date, boolean withTimeZoneT) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (date.getTime() == 9223372036825200000L) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return "infinity";
        }
        if (date.getTime() == -9223372036832400000L) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return "-infinity";
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        calendarT = this.setupCalendar(calendarT);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        calendarT.setTime(date);
        this.s_buf.setLength(0);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        TimestampUtils.appendDate(this.s_buf, calendarT);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        TimestampUtils.appendEra(this.s_buf, calendarT);
        if (withTimeZoneT) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.s_buf.append(' ');
            this.appendTimeZone(this.s_buf, calendarT);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String s = this.s_buf.toString();
        return s;
    }

    public synchronized String toString(Calendar calendar, Time x) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String s = this.toString(calendar, x, true);
        return s;
    }

    public synchronized String toString(Calendar calendar, Time x, boolean withTimeZone) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        calendar = this.setupCalendar(calendar);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        calendar.setTime(x);
        this.s_buf.setLength(0);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        TimestampUtils.appendTime(this.s_buf, calendar, calendar.get(14) * 1000000);
        if (withTimeZone) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.appendTimeZone(this.s_buf, calendar);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        }
        String s = this.s_buf.toString();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return s;
    }

    public synchronized String toString(Calendar calendar, Time x, boolean withTimeZone, long nanoSeconds) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        calendar = this.setupCalendar(calendar);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        calendar.setTime(x);
        this.s_buf.setLength(0);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        TimestampUtils.appendTime(this.s_buf, calendar, calendar.get(14) * 1000000 + (int)nanoSeconds);
        if (withTimeZone) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.appendTimeZone(this.s_buf, calendar);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        }
        String s = this.s_buf.toString();
        return s;
    }

    public long getTimeNanoSecond(byte[] bytes) {
        long nanoSecond = 0L;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.usesDouble) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            double time = ByteConverter.float8(bytes, 0);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            nanoSecond = (long)((time * 1000.0 - (double)((long)(time * 1000.0))) * 1000000.0);
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            long time = ByteConverter.int8(bytes, 0);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            nanoSecond = time % 1000L * 1000L;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return nanoSecond;
    }

    private static void appendDate(StringBuilder sbu, Calendar calendar) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int dayNum = calendar.get(5);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int monthNum = calendar.get(2) + 1;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int yearNum = calendar.get(1);
        TimestampUtils.appendDate(sbu, yearNum, monthNum, dayNum);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    private static void appendDate(StringBuilder sbu, int year, int month, int day) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int prevLength = sbu.length();
        sbu.append(year);
        int leadingZerosForYear = 4 - (sbu.length() - prevLength);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (leadingZerosForYear > 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            sbu.insert(prevLength, ZEROS_T, 0, leadingZerosForYear);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        sbu.append('-');
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        sbu.append(NUMBERS_T[month]);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        sbu.append('-');
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        sbu.append(NUMBERS_T[day]);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    private static void appendTime(StringBuilder sbu, Calendar calendar, int nanos) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int hours = calendar.get(11);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int minutes = calendar.get(12);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int seconds = calendar.get(13);
        TimestampUtils.appendTime(sbu, hours, minutes, seconds, nanos);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    private static void appendTime(StringBuilder stringBuilder, int hours, int minutes, int seconds, int nanosT) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        stringBuilder.append(NUMBERS_T[hours]);
        stringBuilder.append(':');
        stringBuilder.append(NUMBERS_T[minutes]);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        stringBuilder.append(':');
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        stringBuilder.append(NUMBERS_T[seconds]);
        if (nanosT < 1000) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        stringBuilder.append('.');
        int leng = stringBuilder.length();
        stringBuilder.append(nanosT / 1000);
        int needZerosT = 6 - (stringBuilder.length() - leng);
        if (needZerosT > 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            stringBuilder.insert(leng, ZEROS_T, 0, needZerosT);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int endT = stringBuilder.length() - 1;
        while (stringBuilder.charAt(endT) == '0') {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            stringBuilder.deleteCharAt(endT);
            --endT;
        }
    }

    private void appendTimeZone(StringBuilder sbu, Calendar calendar) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int _offset = (calendar.get(15) + calendar.get(16)) / 1000;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.appendTimeZone(sbu, _offset);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    private void appendTimeZone(StringBuilder sbu, int _offset) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int absoff = Math.abs(_offset);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int hours = absoff / 60 / 60;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int mins = (absoff - hours * 60 * 60) / 60;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int seconds = absoff - hours * 60 * 60 - mins * 60;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (CompatibleDB.mysql(compatibleLevel)) {
            return;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        sbu.append(_offset >= 0 ? "+" : "-");
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        sbu.append(NUMBERS_T[hours]);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (mins == 0 && seconds == 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return;
        }
        sbu.append(':');
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        sbu.append(NUMBERS_T[mins]);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (seconds != 0) {
            sbu.append(':');
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            sbu.append(NUMBERS_T[seconds]);
        }
    }

    private static void appendEra(StringBuilder sbu, Calendar calendar) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (calendar.get(0) == 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            sbu.append(" BC");
        }
    }

    public synchronized String toString(LocalDate localDate) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (LocalDate.MAX.equals(localDate)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return "infinity";
        }
        if (localDate.isBefore(MIN_LOCAL_DATE_T)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return "-infinity";
        }
        this.s_buf.setLength(0);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        TimestampUtils.appendDate(this.s_buf, localDate);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        TimestampUtils.appendEra(this.s_buf, localDate);
        String s = this.s_buf.toString();
        return s;
    }

    public synchronized String toString(LocalTime localTimeT) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.s_buf.setLength(0);
        if (localTimeT.isAfter(MAX_TIME_T)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return "24:00:00";
        }
        int nanoT = localTimeT.getNano();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (TimestampUtils.nanosExceed499(nanoT)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            localTimeT = localTimeT.plus(ONE_MICROSECOND_T);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        TimestampUtils.appendTime_(this.s_buf, localTimeT);
        String s = this.s_buf.toString();
        return s;
    }

    public synchronized String toString(OffsetDateTime _offsetDateTime) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (_offsetDateTime.isAfter(MAX_OFFSET_DATETIME_T)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return "infinity";
        }
        if (_offsetDateTime.isBefore(MIN_OFFSET_DATETIME_T)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return "-infinity";
        }
        this.s_buf.setLength(0);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int nano = _offsetDateTime.getNano();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (TimestampUtils.nanosExceed499(nano)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _offsetDateTime = _offsetDateTime.plus(ONE_MICROSECOND_T);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        LocalDateTime localDT = _offsetDateTime.toLocalDateTime();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        LocalDate localDate = localDT.toLocalDate();
        TimestampUtils.appendDate(this.s_buf, localDate);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.s_buf.append(' ');
        TimestampUtils.appendTime_(this.s_buf, localDT.toLocalTime());
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.appendTimeZone(this.s_buf, _offsetDateTime.getOffset());
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        TimestampUtils.appendEra(this.s_buf, localDate);
        String s = this.s_buf.toString();
        return s;
    }

    public synchronized String toString(LocalDateTime localDT) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (localDT.isAfter(MAX_LOCAL_DATETIME_T)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return "infinity";
        }
        if (localDT.isBefore(MIN_LOCAL_DATETIME_T)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return "-infinity";
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        ZonedDateTime zonedDateTime = localDT.atZone(this.getDefaultTz_().toZoneId());
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String s = this.toString(zonedDateTime.toOffsetDateTime());
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return s;
    }

    private static void appendDate(StringBuilder sbu, LocalDate localDate) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int monthNum = localDate.getMonthValue();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int dayNum = localDate.getDayOfMonth();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int yearNum = localDate.get(ChronoField.YEAR_OF_ERA);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        TimestampUtils.appendDate(sbu, yearNum, monthNum, dayNum);
    }

    private static void appendTime_(StringBuilder sbu, LocalTime localTime) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int hours = localTime.getHour();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int minutes = localTime.getMinute();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int seconds = localTime.getSecond();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int nanos = localTime.getNano();
        TimestampUtils.appendTime(sbu, hours, minutes, seconds, nanos);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    private void appendTimeZone(StringBuilder sbu, ZoneOffset _offset) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int _offsetSeconds = _offset.getTotalSeconds();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.appendTimeZone(sbu, _offsetSeconds);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    private static void appendEra(StringBuilder sbu, LocalDate localDate) {
        if (localDate.get(ChronoField.ERA) == IsoEra.BCE.getValue()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            sbu.append(" BC");
        }
    }

    private static int skipWhitespace(char[] s, int _start) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int sleng = s.length;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        for (int i = _start; i < sleng; ++i) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (Character.isSpace(s[i])) continue;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return i;
        }
        return sleng;
    }

    private static int firstNonDigit(char[] s, int _start) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int sleng = s.length;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        for (int i = _start; i < sleng; ++i) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (Character.isDigit(s[i])) continue;
            return i;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return sleng;
    }

    private static int number(char[] s, int _start, int end) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (_start >= end) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new NumberFormatException();
        }
        int n = 0;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        for (int i = _start; i < end; ++i) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            n = 10 * n + (s[i] - 48);
        }
        return n;
    }

    private static char charAt(char[] s, int position) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (position >= 0 && position < s.length) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return s[position];
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return '\u0000';
    }

    public Date toDateBin(TimeZone timezone, byte[] _bytes) throws KSQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (_bytes.length != 4) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String info = "Unsupported binary _encoding of {0}.";
            throw new KSQLException(GT.tr("Unsupported binary _encoding of {0}.", "date"), KSQLState.BAD_DATETIME_FORMAT);
        }
        int days = ByteConverter.int4(_bytes, 0);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (timezone == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            timezone = this.getDefaultTz_();
        }
        long seconds = TimestampUtils.toJavaSecs((long)days * 86400L);
        long milliseconds = seconds * 1000L;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (milliseconds <= -185543533774800000L) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            milliseconds = -9223372036832400000L;
        } else if (milliseconds >= 185543533774800000L) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            milliseconds = 9223372036825200000L;
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            milliseconds = this.guessTimestamp(milliseconds, timezone);
        }
        Date date = new Date(milliseconds);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return date;
    }

    private TimeZone getDefaultTz_() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (DEFAULT_TIME_ZONE_FIELD_T != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            try {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                TimeZone defaultTimeZoneT = (TimeZone)DEFAULT_TIME_ZONE_FIELD_T.get(null);
                if (defaultTimeZoneT == this.prevDefaultZoneFieldVal_T) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    return this.defaultTimeZoneCache_T;
                }
                this.prevDefaultZoneFieldVal_T = defaultTimeZoneT;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            }
            catch (Exception exception) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            }
        }
        TimeZone timezoneT = TimeZone.getDefault();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.defaultTimeZoneCache_T = timezoneT;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return timezoneT;
    }

    public boolean hasFastDefaultTimeZone() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        boolean b = DEFAULT_TIME_ZONE_FIELD_T != null;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return b;
    }

    public Time toTimeBin(TimeZone timezone, byte[] _bytes) throws KSQLException {
        long milliseconds;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (_bytes.length != 8 && _bytes.length != 12) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String info = "Unsupported binary _encoding of {0}.";
            throw new KSQLException(GT.tr("Unsupported binary _encoding of {0}.", "time"), KSQLState.BAD_DATETIME_FORMAT);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.usesDouble) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            double time = ByteConverter.float8(_bytes, 0);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            milliseconds = (long)(time * 1000.0);
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            long time = ByteConverter.int8(_bytes, 0);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            milliseconds = time / 1000L;
        }
        if (_bytes.length == 12) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int timeOffset = ByteConverter.int4(_bytes, 8);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            Time time = new Time(milliseconds -= (long)(timeOffset *= -1000));
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return time;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (timezone == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            timezone = this.getDefaultTz_();
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        milliseconds = this.guessTimestamp(milliseconds, timezone);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Time time = this.convertToTime(milliseconds, timezone);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return time;
    }

    public LocalTime toLocalTimeBin(byte[] _bytes) throws KSQLException {
        long micros;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (_bytes.length != 8) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String info = "Unsupported binary _encoding of {0}.";
            throw new KSQLException(GT.tr("Unsupported binary _encoding of {0}.", "time"), KSQLState.BAD_DATETIME_FORMAT);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.usesDouble) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            double seconds = ByteConverter.float8(_bytes, 0);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            micros = (long)(seconds * 1000000.0);
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            micros = ByteConverter.int8(_bytes, 0);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        LocalTime localTime = LocalTime.ofNanoOfDay(micros * 1000L);
        return localTime;
    }

    public Timestamp toTimestampBin(TimeZone timezone, byte[] _bytes, boolean timestamptz) throws KSQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        ParsedBinaryTimestampT parsedtimestamp = this.toParsedTimestampBin(timezone, _bytes, timestamptz);
        if (parsedtimestamp.infinity == EInfinity.POSITIVE) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return new Timestamp(9223372036825200000L);
        }
        if (parsedtimestamp.infinity == EInfinity.NEGATIVE) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return new Timestamp(-9223372036832400000L);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Timestamp timestamp = new Timestamp(parsedtimestamp.milliseconds);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        timestamp.setNanos(parsedtimestamp.nanos);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return timestamp;
    }

    private ParsedBinaryTimestampT toParsedTimestampBinPlain(byte[] _bytes) throws KSQLException {
        int nanos;
        long seconds;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (_bytes.length != 8) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("Unsupported binary _encoding of {0}.", "timestamp"), KSQLState.BAD_DATETIME_FORMAT);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.usesDouble) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            double time = ByteConverter.float8(_bytes, 0);
            if (time == Double.POSITIVE_INFINITY) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                ParsedBinaryTimestampT timestamp = new ParsedBinaryTimestampT();
                timestamp.infinity = EInfinity.POSITIVE;
                return timestamp;
            }
            if (time == Double.NEGATIVE_INFINITY) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                ParsedBinaryTimestampT timestamp = new ParsedBinaryTimestampT();
                timestamp.infinity = EInfinity.NEGATIVE;
                return timestamp;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            seconds = (long)time;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            nanos = (int)((time - (double)seconds) * 1000000.0);
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            long time = ByteConverter.int8(_bytes, 0);
            if (time == Long.MAX_VALUE) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                ParsedBinaryTimestampT timestamp = new ParsedBinaryTimestampT();
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                timestamp.infinity = EInfinity.POSITIVE;
                return timestamp;
            }
            if (time == Long.MIN_VALUE) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                ParsedBinaryTimestampT timestamp = new ParsedBinaryTimestampT();
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                timestamp.infinity = EInfinity.NEGATIVE;
                return timestamp;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            seconds = time / 1000000L;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            nanos = (int)(time - seconds * 1000000L);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        }
        if (nanos < 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            --seconds;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            nanos += 1000000;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        nanos *= 1000;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        long milliseconds = seconds * 1000L;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        ParsedBinaryTimestampT timestamp = new ParsedBinaryTimestampT();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        timestamp.milliseconds = milliseconds;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        timestamp.nanos = nanos;
        return timestamp;
    }

    private ParsedBinaryTimestampT toParsedTimestampBin(TimeZone timezone, byte[] _bytes, boolean timestamptz) throws KSQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        ParsedBinaryTimestampT timestamp = this.toParsedTimestampBinPlain(_bytes);
        if (timestamp.infinity != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return timestamp;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        long seconds = timestamp.milliseconds / 1000L;
        seconds = TimestampUtils.toJavaSecs(seconds);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        long milliseconds = seconds * 1000L;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (!timestamptz) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            milliseconds = this.guessTimestamp(milliseconds, timezone);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        timestamp.milliseconds = milliseconds;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return timestamp;
    }

    private ParsedBinaryTimestampT toProlepticParsedTimestampBin(byte[] _bytes) throws KSQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        ParsedBinaryTimestampT timestamp = this.toParsedTimestampBinPlain(_bytes);
        if (timestamp.infinity != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return timestamp;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        long seconds = timestamp.milliseconds / 1000L;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        long milliseconds = (seconds += 946684800L) * 1000L;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        timestamp.milliseconds = milliseconds;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return timestamp;
    }

    public LocalDateTime toLocalDateTimeBin(byte[] _bytes) throws KSQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        ParsedBinaryTimestampT parsedtimestamp = this.toProlepticParsedTimestampBin(_bytes);
        if (parsedtimestamp.infinity == EInfinity.POSITIVE) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return LocalDateTime.MAX;
        }
        if (parsedtimestamp.infinity == EInfinity.NEGATIVE) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return LocalDateTime.MIN;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        long epochSecond = parsedtimestamp.milliseconds / 1000L;
        int nanos = parsedtimestamp.nanos;
        LocalDateTime localDateTime = LocalDateTime.ofEpochSecond(epochSecond, nanos, ZoneOffset.UTC);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return localDateTime;
    }

    private long guessTimestamp(long millisecondsT, TimeZone timezone) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (timezone == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            timezone = this.getDefaultTz_();
        }
        if (TimestampUtils.isSimpleTimeZone_(timezone.getID())) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            long l = millisecondsT - (long)timezone.getRawOffset();
            return l;
        }
        Calendar userCalendarT = this.calWithUserTz;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        userCalendarT.setTimeZone(this.utcTimeZone);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        userCalendarT.setTimeInMillis(millisecondsT);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int msT = userCalendarT.get(14);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int minT = userCalendarT.get(12);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int secT = userCalendarT.get(13);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int yearT = userCalendarT.get(1);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int monthT = userCalendarT.get(2);
        int dayT = userCalendarT.get(5);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int eraT = userCalendarT.get(0);
        int hourT = userCalendarT.get(11);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        userCalendarT.setTimeZone(timezone);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        userCalendarT.set(14, msT);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        userCalendarT.set(13, secT);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        userCalendarT.set(11, hourT);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        userCalendarT.set(1, yearT);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        userCalendarT.set(2, monthT);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        userCalendarT.set(5, dayT);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        userCalendarT.set(0, eraT);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        userCalendarT.set(12, minT);
        long timeInMillis = userCalendarT.getTimeInMillis();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return timeInMillis;
    }

    private static boolean isSimpleTimeZone_(String id) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        boolean b = id.startsWith("GMT") || id.startsWith("UTC");
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return b;
    }

    public Date convertToDate(long millisecondsT, TimeZone timezone) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (millisecondsT <= -9223372036832400000L || millisecondsT >= 9223372036825200000L) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            Date date = new Date(millisecondsT);
            return date;
        }
        if (timezone == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            timezone = this.getDefaultTz_();
        }
        if (TimestampUtils.isSimpleTimeZone_(timezone.getID())) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int _offset = timezone.getRawOffset();
            millisecondsT += (long)_offset;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            millisecondsT = TimestampUtils.floorDiv_(millisecondsT, 86400000L) * 86400000L;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            Date date = new Date(millisecondsT -= (long)_offset);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return date;
        }
        Calendar userCalendarT = this.calWithUserTz;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        userCalendarT.setTimeZone(timezone);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        userCalendarT.setTimeInMillis(millisecondsT);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        userCalendarT.set(14, 0);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        userCalendarT.set(12, 0);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        userCalendarT.set(13, 0);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        userCalendarT.set(11, 0);
        Date date = new Date(userCalendarT.getTimeInMillis());
        return date;
    }

    public Time convertToTime(long millisecondsT, TimeZone timezone) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (timezone == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            timezone = this.getDefaultTz_();
        }
        if (TimestampUtils.isSimpleTimeZone_(timezone.getID())) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int _offset = timezone.getRawOffset();
            millisecondsT += (long)_offset;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            millisecondsT = TimestampUtils.floorMod(millisecondsT, 86400000L);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            Time time = new Time(millisecondsT -= (long)_offset);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return time;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Calendar userCalendarT = this.calWithUserTz;
        userCalendarT.setTimeZone(timezone);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        userCalendarT.setTimeInMillis(millisecondsT);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        userCalendarT.set(5, 1);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        userCalendarT.set(2, 0);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        userCalendarT.set(1, 1970);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        userCalendarT.set(0, 1);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Time time = new Time(userCalendarT.getTimeInMillis());
        return time;
    }

    public String timeToString(java.util.Date time, boolean withTimeZone) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Calendar calendar = null;
        if (withTimeZone) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            calendar = this.calWithUserTz;
            calendar.setTimeZone(this.tzProvider.get());
        }
        if (time instanceof Timestamp) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String s = this.toString(calendar, (Timestamp)time, withTimeZone);
            return s;
        }
        if (time instanceof Time) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return this.toString(calendar, (Time)time, withTimeZone);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.toString(calendar, (Date)time, withTimeZone);
    }

    public String timeToString(java.util.Date time, boolean withTimeZone, long nanoSecond) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Calendar calendar = null;
        if (withTimeZone) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            calendar = this.calWithUserTz;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            calendar.setTimeZone(this.tzProvider.get());
        }
        if (time instanceof Timestamp) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return this.toString(calendar, (Timestamp)time, withTimeZone);
        }
        if (time instanceof Time) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String s = this.toString(calendar, (Time)time, withTimeZone, nanoSecond);
            return s;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String s = this.toString(calendar, (Date)time, withTimeZone);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return s;
    }

    private static long toJavaSecs(long seconds) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if ((seconds += 946684800L) < -12219292800L) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if ((seconds += 864000L) < -14825808000L) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                int extraLeapst = (int)((seconds + 14825808000L) / 3155760000L);
                --extraLeapst;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                extraLeapst -= extraLeapst / 4;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                seconds += (long)extraLeapst * 86400L;
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return seconds;
    }

    private static long toPgSecs(long seconds) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if ((seconds -= 946684800L) < -13165977600L) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if ((seconds -= 864000L) < -15773356800L) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                int years = (int)((seconds + 15773356800L) / -3155823050L);
                ++years;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                years -= years / 4;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                seconds += (long)years * 86400L;
            }
        }
        return seconds;
    }

    public void toBinDate(TimeZone timezone, byte[] _bytes, Date _value) throws KSQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        long milliseconds = _value.getTime();
        if (timezone == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            timezone = this.getDefaultTz_();
        }
        milliseconds += (long)timezone.getOffset(milliseconds);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        long seconds = TimestampUtils.toPgSecs(milliseconds / 1000L);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        ByteConverter.int4(_bytes, 0, (int)(seconds / 86400L));
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public static TimeZone parseBackendTimeZone(String tz) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (tz.startsWith("GMT")) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            TimeZone timezone = ZONES_IN_GMT.get(tz);
            if (timezone != null) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return timezone;
            }
        }
        TimeZone timeZone = TimeZone.getTimeZone(tz);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return timeZone;
    }

    private static long floorDiv_(long xT, long yT) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        long rT = xT / yT;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if ((xT ^ yT) < 0L && rT * yT != xT) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            --rT;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return rT;
    }

    private static long floorMod(long xT, long yT) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        long l = xT - TimestampUtils.floorDiv_(xT, yT) * yT;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return l;
    }

    static {
        Field timezoneFieldT;
        int i;
        ZEROS_T = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0'};
        ZONES_IN_GMT = new HashMap<String, TimeZone>();
        MAX_OFFSET_DATETIME_T = OffsetDateTime.MAX.minus(Duration.ofMillis(500L));
        MIN_LOCAL_DATE_T = LocalDate.of(4713, 1, 1).with(ChronoField.ERA, IsoEra.BCE.getValue());
        ONE_MICROSECOND_T = Duration.ofNanos(1000L);
        MIN_LOCAL_DATETIME_T = MIN_LOCAL_DATE_T.atStartOfDay();
        MAX_LOCAL_DATETIME_T = LocalDateTime.MAX.minus(Duration.ofMillis(500L));
        MAX_TIME_T = LocalTime.MAX.minus(Duration.ofMillis(500L));
        MIN_OFFSET_DATETIME_T = MIN_LOCAL_DATETIME_T.atOffset(ZoneOffset.UTC);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        NUMBERS_T = new char[64][];
        for (i = 0; i < NUMBERS_T.length; ++i) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            TimestampUtils.NUMBERS_T[i] = ((i < 10 ? "0" : "") + Integer.toString(i)).toCharArray();
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        for (i = -12; i <= 14; ++i) {
            String pgZoneNameT;
            TimeZone tzT;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (i == 0) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                tzT = TimeZone.getTimeZone("GMT");
                pgZoneNameT = "GMT";
            } else {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                String tStr = "GMT" + (i <= 0 ? "+" : "-") + Math.abs(i);
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                tzT = TimeZone.getTimeZone(tStr);
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                pgZoneNameT = "GMT" + (i >= 0 ? "+" : "-");
            }
            if (i == 0) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                ZONES_IN_GMT.put(pgZoneNameT, tzT);
                continue;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            ZONES_IN_GMT.put(pgZoneNameT + Math.abs(i), tzT);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            ZONES_IN_GMT.put(pgZoneNameT + new String(NUMBERS_T[Math.abs(i)]), tzT);
        }
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            timezoneFieldT = null;
            if (JavaVersion.getRuntimeVersion().compareTo(JavaVersion.version_1_8) <= 0) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                timezoneFieldT = TimeZone.class.getDeclaredField("defaultTimeZone");
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                timezoneFieldT.setAccessible(true);
                TimeZone defaultTz = TimeZone.getDefault();
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                Object timezoneFromField = timezoneFieldT.get(null);
                if (defaultTz == null || !defaultTz.equals(timezoneFromField)) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    timezoneFieldT = null;
                }
            }
        }
        catch (Exception exception) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            timezoneFieldT = null;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        DEFAULT_TIME_ZONE_FIELD_T = timezoneFieldT;
    }

    static enum EInfinity {
        POSITIVE,
        NEGATIVE;

    }

    private static class ParsedBinaryTimestampT {
        long milliseconds = 0L;
        int nanos = 0;
        EInfinity infinity = null;

        private ParsedBinaryTimestampT() {
        }
    }

    private static class ParsedTimestamp {
        int day = 1;
        boolean hasTimeVal = false;
        int minute = 0;
        int hour = 0;
        int nanos = 0;
        int second = 0;
        int era = 1;
        boolean hasDate = false;
        int beginMonth = 1;
        int beginYear = 1970;
        Calendar timezone = null;

        private ParsedTimestamp() {
        }
    }
}

