/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.osgi;

import com.kingbase8.Driver;
import com.kingbase8.ds.common.BaseDataSource;
import com.kingbase8.jdbc2.optional.ConnectionPool;
import com.kingbase8.jdbc2.optional.PoolingDataSource;
import com.kingbase8.jdbc2.optional.SimpleDataSource;
import com.kingbase8.util.GT;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import com.kingbase8.util.TraceLogger;
import com.kingbase8.xa.KBXADataSource;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.osgi.service.jdbc.DataSourceFactory;

public class KBDataSourceFactory
implements DataSourceFactory {
    private void configureBaseDataSource_(BaseDataSource baseDataSource, Properties properties) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (properties.containsKey("url")) {
            baseDataSource.setUrl(properties.getProperty("url"));
        }
        if (properties.containsKey("serverName")) {
            baseDataSource.setServerName(properties.getProperty("serverName"));
        }
        if (properties.containsKey("portNumber")) {
            baseDataSource.setPortNumber(Integer.parseInt(properties.getProperty("portNumber")));
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (properties.containsKey("databaseName")) {
            baseDataSource.setDatabaseName(properties.getProperty("databaseName"));
        }
        if (properties.containsKey("user")) {
            baseDataSource.setUser(properties.getProperty("user"));
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (properties.containsKey("password")) {
            baseDataSource.setPassword(properties.getProperty("password"));
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        for (Map.Entry<Object, Object> entryT : properties.entrySet()) {
            baseDataSource.setProperty((String)entryT.getKey(), (String)entryT.getValue());
        }
    }

    public java.sql.Driver createDriver(Properties properties) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (properties != null && !properties.isEmpty()) {
            throw new KSQLException(GT.tr("Unsupported propes: {0}", properties.stringPropertyNames()), KSQLState.INVALID_PARAMETER_VALUE);
        }
        return new Driver();
    }

    private DataSource createPoolingDataSource_(Properties properties) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        PoolingDataSource poolingDataSource = new PoolingDataSource();
        if (properties.containsKey("initialPoolSize")) {
            poolingDataSource.setInitialConnections(Integer.parseInt(properties.getProperty("initialPoolSize")));
        }
        if (properties.containsKey("maxPoolSize")) {
            poolingDataSource.setMaxConnections(Integer.parseInt(properties.getProperty("maxPoolSize")));
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (properties.containsKey("dataSourceName")) {
            poolingDataSource.setDataSourceName(properties.getProperty("dataSourceName"));
        }
        this.configureBaseDataSource_(poolingDataSource, properties);
        return poolingDataSource;
    }

    private DataSource createSimpleDataSource_(Properties properties) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        SimpleDataSource simpleDataSource = new SimpleDataSource();
        this.configureBaseDataSource_(simpleDataSource, properties);
        return simpleDataSource;
    }

    public DataSource createDataSource(Properties properties) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        properties = new SingleUseProperties(properties);
        if (properties.containsKey("initialPoolSize") || properties.containsKey("minPoolSize") || properties.containsKey("maxPoolSize") || properties.containsKey("maxIdleTime") || properties.containsKey("maxStatements")) {
            return this.createPoolingDataSource_(properties);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.createSimpleDataSource_(properties);
    }

    public ConnectionPoolDataSource createConnectionPoolDataSource(Properties properties) throws SQLException {
        properties = new SingleUseProperties(properties);
        ConnectionPool connectionPool = new ConnectionPool();
        this.configureBaseDataSource_(connectionPool, properties);
        return connectionPool;
    }

    public XADataSource createXADataSource(Properties properties) throws SQLException {
        properties = new SingleUseProperties(properties);
        KBXADataSource xaDataSource = new KBXADataSource();
        this.configureBaseDataSource_(xaDataSource, properties);
        return xaDataSource;
    }

    private static class SingleUseProperties
    extends Properties {
        private static final long serialVersionUID = 6756215081039908843L;

        SingleUseProperties(Properties initialPropsT) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (initialPropsT != null) {
                this.putAll((Map<?, ?>)initialPropsT);
            }
        }

        @Override
        public String getProperty(String _key) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String _value = super.getProperty(_key);
            this.remove(_key);
            return _value;
        }
    }
}

