/*
 * Decompiled with CFR 0.152.
 */
package cn.com.pism.ezasse.executor;

import cn.com.pism.ezasse.model.EzasseTableInfo;
import cn.com.pism.ezasse.util.EzasseUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.sql.DataSource;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.CollectionUtils;

public abstract class EzasseExecutor {
    protected static final Log log = LogFactory.getLog(EzasseExecutor.class);
    protected JdbcTemplate jdbcTemplate;
    protected DataSource dataSource;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    public <T> T queryForObject(String sql, Class<T> clazz) {
        return (T)this.jdbcTemplate.queryForObject(sql, clazz);
    }

    public <T> List<T> queryForList(Class<T> clazz, String sql, Objects ... args) {
        return this.jdbcTemplate.queryForList(sql, clazz, (Object[])args);
    }

    public abstract List<EzasseTableInfo> getTableInfo(String var1, String var2);

    public abstract List<EzasseTableInfo> getTableInfo(String var1);

    public void execute(String sql) {
        this.jdbcTemplate.execute(sql);
    }

    protected static String getDataBaseNameFromDataSource(DataSource dataSource) {
        String catalog = EzasseUtil.getFromDataSource(dataSource, connection -> {
            try {
                return connection.getCatalog();
            }
            catch (SQLException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
                return "";
            }
        });
        if (StringUtils.isBlank((CharSequence)catalog)) {
            return "";
        }
        return catalog;
    }

    public abstract String getId();

    protected List<EzasseTableInfo> toTableInfo(List<Map<String, Object>> mapList) {
        if (CollectionUtils.isEmpty(mapList)) {
            return Collections.emptyList();
        }
        ArrayList<EzasseTableInfo> tableInfos = new ArrayList<EzasseTableInfo>();
        mapList.forEach(map -> {
            EzasseTableInfo tableInfo = new EzasseTableInfo();
            tableInfo.setColumnName(MapUtils.getString((Map)map, (Object)"columnName"));
            tableInfo.setDataType(MapUtils.getString((Map)map, (Object)"dataType"));
            tableInfo.setCharacterMaximumLength(MapUtils.getString((Map)map, (Object)"characterMaximumLength"));
            tableInfo.setColumnComment(MapUtils.getString((Map)map, (Object)"columnComment"));
            tableInfos.add(tableInfo);
        });
        return tableInfos;
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }
}

