/*
 * Decompiled with CFR 0.152.
 */
package cn.com.pism.ezasse.executor;

import cn.com.pism.ezasse.executor.EzasseExecutor;
import cn.com.pism.ezasse.model.EzasseTableInfo;
import cn.com.pism.ezasse.util.EzasseLogUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.datasource.init.ScriptUtils;

public class OracleEzasseExecutor
extends EzasseExecutor {
    private static final String SQL = "SELECT UTC.COLUMN_NAME columnName,\n       UTC.DATA_TYPE   dataType,\n       UTC.CHAR_LENGTH characterMaximumLength,\n       UCC.COMMENTS    columnComment\nFROM USER_TAB_COLS UTC\n         LEFT JOIN USER_COL_COMMENTS UCC ON UTC.TABLE_NAME = UCC.TABLE_NAME AND UTC.COLUMN_NAME = UCC.COLUMN_NAME\nWHERE UTC.TABLE_NAME = ?\n";

    @Override
    public List<EzasseTableInfo> getTableInfo(String tableName, String columnName) {
        String querySql = "SELECT UTC.COLUMN_NAME columnName,\n       UTC.DATA_TYPE   dataType,\n       UTC.CHAR_LENGTH characterMaximumLength,\n       UCC.COMMENTS    columnComment\nFROM USER_TAB_COLS UTC\n         LEFT JOIN USER_COL_COMMENTS UCC ON UTC.TABLE_NAME = UCC.TABLE_NAME AND UTC.COLUMN_NAME = UCC.COLUMN_NAME\nWHERE UTC.TABLE_NAME = ?\nAND UTC.COLUMN_NAME = ?";
        List queryForList = this.jdbcTemplate.queryForList(querySql, new Object[]{tableName, columnName});
        return this.toTableInfo(queryForList);
    }

    @Override
    public List<EzasseTableInfo> getTableInfo(String tableName) {
        List queryForList = this.jdbcTemplate.queryForList(SQL, new Object[]{tableName});
        return this.toTableInfo(queryForList);
    }

    @Override
    public void execute(String sql) {
        try {
            ByteArrayResource resource = new ByteArrayResource(sql.getBytes());
            ScriptUtils.executeSqlScript((Connection)super.getDataSource().getConnection(), (Resource)resource);
        }
        catch (SQLException e) {
            EzasseLogUtil.error(log, e.getMessage());
        }
    }

    @Override
    public String getId() {
        return "ORACLE";
    }
}

