/*
 * Decompiled with CFR 0.152.
 */
package cn.com.pism.ezasse.util;

import cn.com.pism.ezasse.util.Callback;
import cn.com.pism.ezasse.util.EzasseLogUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Locale;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EzasseUtil {
    private static final Log log = LogFactory.getLog(EzasseUtil.class);

    private EzasseUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T getFromDataSource(DataSource dataSource, Callback<Connection, T> callback) {
        if (dataSource == null) {
            return null;
        }
        Connection connection = null;
        try {
            connection = dataSource.getConnection();
            T t = callback.call(connection);
            return t;
        }
        catch (SQLException e) {
            EzasseLogUtil.error(log, e.getMessage());
            T t = null;
            return t;
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    EzasseLogUtil.error(log, e.getMessage());
                }
            }
        }
    }

    public static String getDatabaseTypeFromDataSource(DataSource dataSource) {
        String databaseType = EzasseUtil.getFromDataSource(dataSource, connection -> {
            try {
                return connection.getMetaData().getDatabaseProductName().toUpperCase(Locale.ROOT);
            }
            catch (SQLException e) {
                EzasseLogUtil.error(log, e.getMessage());
                return "UNKNOWN";
            }
        });
        if (databaseType == null) {
            return "UNKNOWN";
        }
        return databaseType;
    }
}

