/*
 * Decompiled with CFR 0.152.
 */
package cn.com.pism.ezasse;

import cn.com.pism.ezasse.EzasseGroupParser;
import cn.com.pism.ezasse.checker.DefaultKeyWordEzasseChecker;
import cn.com.pism.ezasse.checker.EzasseChecker;
import cn.com.pism.ezasse.checker.TableEzasseChecker;
import cn.com.pism.ezasse.checker.change.ChangeAddEzasseChecker;
import cn.com.pism.ezasse.checker.change.ChangeCommentEzasseChecker;
import cn.com.pism.ezasse.checker.change.ChangeLengthEzasseChecker;
import cn.com.pism.ezasse.checker.change.ChangeNameEzasseChecker;
import cn.com.pism.ezasse.checker.change.ChangeTypeEzasseChecker;
import cn.com.pism.ezasse.enums.EzasseExceptionCode;
import cn.com.pism.ezasse.exception.EzasseException;
import cn.com.pism.ezasse.executor.EzasseExecutor;
import cn.com.pism.ezasse.executor.H2EzasseExecutor;
import cn.com.pism.ezasse.executor.HsqlDbExecutor;
import cn.com.pism.ezasse.executor.MariaDbEzasseExecutor;
import cn.com.pism.ezasse.executor.MysqlEzasseExecutor;
import cn.com.pism.ezasse.executor.OracleEzasseExecutor;
import cn.com.pism.ezasse.model.EzasseCheckNode;
import cn.com.pism.ezasse.model.EzasseConfig;
import cn.com.pism.ezasse.model.EzasseSql;
import cn.com.pism.ezasse.util.EzasseLogUtil;
import cn.com.pism.ezasse.util.EzasseUtil;
import cn.com.pism.frc.resourcescanner.JavaMigration;
import cn.com.pism.frc.resourcescanner.Location;
import cn.com.pism.frc.resourcescanner.LocationScannerCache;
import cn.com.pism.frc.resourcescanner.ResourceNameCache;
import cn.com.pism.frc.resourcescanner.Scanner;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Ezasse {
    private static final Log log = LogFactory.getLog(Ezasse.class);
    private EzasseConfig config;
    private final Map<String, DataSource> dataSourceMap = new HashMap<String, DataSource>(0);
    private final Map<String, EzasseChecker> checkerMap;
    private final Map<String, EzasseExecutor> executorMap = new HashMap<String, EzasseExecutor>(0);
    private DataSource master;
    public static final String MASTER_ID = "master";

    public void setConfig(EzasseConfig config) {
        this.config = config;
    }

    public void setMaster(DataSource master) {
        this.master = master;
    }

    public Ezasse() {
        this.checkerMap = new HashMap<String, EzasseChecker>(0);
        this.initExecutor();
    }

    public void executeScript() {
        this.dataSourceMap.put(MASTER_ID, this.master);
        List<EzasseSql> ezasseSqls = this.getEzasseSqlList(this.config);
        this.printLog(ezasseSqls);
        Map<String, List<EzasseSql>> ezasseSqlMap = ezasseSqls.stream().collect(Collectors.groupingBy(EzasseSql::getGroup));
        List<String> groupOrder = this.config.getGroupOrder();
        if (CollectionUtils.isEmpty(groupOrder) && ezasseSqlMap.size() > 1) {
            throw new EzasseException(EzasseExceptionCode.UNSPECIFIED_GROUP_EXCEPTION);
        }
        if (CollectionUtils.isEmpty(groupOrder)) {
            ezasseSqlMap.forEach((k, v) -> this.groupParsing(this.config, (List<EzasseSql>)v));
        } else {
            groupOrder.forEach(order -> this.groupParsing(this.config, (List)ezasseSqlMap.get(order)));
        }
    }

    private void printLog(List<EzasseSql> ezasseSqls) {
        EzasseLogUtil.info(log, "Ezasse - Identified file list");
        EzasseLogUtil.info(log, String.format("%-8s %-8s %-8s %-20s %-20s", "group", "order", "node", "name", "path"));
        for (EzasseSql ezasseSql : ezasseSqls) {
            EzasseLogUtil.info(log, String.format("%-8s %-8s %-8s %-20s %-20s", ezasseSql.getGroup(), ezasseSql.getOrder(), ezasseSql.getNode(), ezasseSql.getName(), ezasseSql.getPath()));
        }
    }

    private void groupParsing(EzasseConfig config, List<EzasseSql> ezasseSqls) {
        if (CollectionUtils.isNotEmpty(ezasseSqls)) {
            ezasseSqls.stream().sorted((o1, o2) -> {
                String order1 = StringUtils.isNotBlank((CharSequence)o1.getOrder()) ? o1.getOrder() : "000";
                String order2 = StringUtils.isNotBlank((CharSequence)o2.getOrder()) ? o2.getOrder() : "000";
                return Integer.parseInt(order1) - Integer.parseInt(order2);
            }).forEach(sql -> this.doGroupParsing(config, (EzasseSql)sql));
        }
    }

    private void doGroupParsing(EzasseConfig config, EzasseSql sql) {
        EzasseGroupParser parser = new EzasseGroupParser(config, sql, this.checkerMap.keySet());
        LinkedHashMap<String, String> scriptMap = parser.parser();
        scriptMap.forEach((k, v) -> this.doExecuteScript((String)k, (String)v, sql));
    }

    private void doExecuteScript(String checkLine, String sqlLine, EzasseSql ezasseSql) {
        if (StringUtils.isNotBlank((CharSequence)sqlLine)) {
            EzasseCheckNode ezasseCheckNode = new EzasseCheckNode(checkLine, ezasseSql, this.dataSourceMap);
            EzasseChecker ezasseChecker = this.checkerMap.get(ezasseCheckNode.getCheckKey());
            EzasseExecutor checkEzasseExecutor = this.getExecutorByDatasource(ezasseCheckNode.getCheckNode());
            checkEzasseExecutor.setDataSource(ezasseCheckNode.getCheckNode());
            if (ezasseChecker.needToExecute(ezasseCheckNode.getCheckNode(), ezasseCheckNode.getCheckContent(), checkEzasseExecutor)) {
                EzasseLogUtil.debug(log, "Ezasse - execute code block :" + checkLine);
                EzasseExecutor ezasseExecutor = this.getExecutorByDatasource(ezasseCheckNode.getExecNode());
                ezasseExecutor.setDataSource(ezasseCheckNode.getExecNode());
                ezasseExecutor.execute(sqlLine);
            }
        }
    }

    private List<EzasseSql> getEzasseSqlList(EzasseConfig config) {
        String folder = config.getFolder();
        if (StringUtils.isBlank((CharSequence)folder)) {
            throw new EzasseException(EzasseExceptionCode.UNSPECIFIED_FOLDER_EXCEPTION);
        }
        ArrayList<Location> locations = new ArrayList<Location>();
        if (folder.startsWith("classpath:")) {
            locations.add(new Location(folder));
        } else {
            locations.add(new Location("classpath:" + folder));
        }
        Scanner scanner = new Scanner(JavaMigration.class, locations, Thread.currentThread().getContextClassLoader(), StandardCharsets.UTF_8, new ResourceNameCache(), new LocationScannerCache());
        Collection resources = scanner.getResources("", new String[]{".sql"});
        List<String> fileList = config.getFileList();
        if (CollectionUtils.isNotEmpty(fileList)) {
            resources = resources.stream().filter(r -> {
                for (String file : fileList) {
                    if (!r.getFilename().startsWith(file)) continue;
                    return true;
                }
                return false;
            }).collect(Collectors.toCollection(ArrayList::new));
        }
        ArrayList<EzasseSql> ezasseSqls = new ArrayList<EzasseSql>();
        resources.forEach(r -> ezasseSqls.add(this.absolutePathToEzasseSql(r.getAbsolutePath())));
        return ezasseSqls;
    }

    private EzasseSql absolutePathToEzasseSql(String absolutePath) {
        String[] absolutePathSplit = absolutePath.split("/");
        String fileName = absolutePathSplit[absolutePathSplit.length - 1];
        String filePath = absolutePath.substring(0, absolutePath.lastIndexOf("/") + 1);
        String[] split = fileName.split("-");
        EzasseSql ezasseSql = new EzasseSql();
        ezasseSql.setGroup(split[0].replace(".sql", ""));
        ezasseSql.setName(fileName);
        ezasseSql.setParentPath(filePath);
        ezasseSql.setPath(absolutePath);
        for (int i = 1; i < split.length; ++i) {
            String toBeConfirmed = split[i];
            if (NumberUtils.isDigits((String)toBeConfirmed)) {
                ezasseSql.setOrder(toBeConfirmed);
            }
            if (this.dataSourceMap.get(toBeConfirmed) == null) continue;
            ezasseSql.setNode(toBeConfirmed);
        }
        return ezasseSql;
    }

    public void addChecker(EzasseChecker ezasseChecker) {
        String id = ezasseChecker.getId(this.config);
        this.checkerMap.remove(id);
        this.checkerMap.put(id, ezasseChecker);
    }

    public void addDataSource(String id, DataSource dataSource) {
        this.dataSourceMap.remove(id);
        this.dataSourceMap.put(id, dataSource);
    }

    public void addExecutor(EzasseExecutor executor) {
        this.executorMap.remove(executor.getId());
        this.executorMap.put(executor.getId(), executor);
    }

    public EzasseExecutor getExecutorByDatasource(DataSource dataSource) {
        return this.executorMap.get(EzasseUtil.getDatabaseTypeFromDataSource(dataSource));
    }

    public void initChecker() {
        this.addChecker(new DefaultKeyWordEzasseChecker());
        this.addChecker(new TableEzasseChecker());
        this.addChecker(new ChangeAddEzasseChecker());
        this.addChecker(new ChangeNameEzasseChecker());
        this.addChecker(new ChangeTypeEzasseChecker());
        this.addChecker(new ChangeLengthEzasseChecker());
        this.addChecker(new ChangeCommentEzasseChecker());
    }

    private void initExecutor() {
        this.addExecutor(new MysqlEzasseExecutor());
        this.addExecutor(new OracleEzasseExecutor());
        this.addExecutor(new H2EzasseExecutor());
        this.addExecutor(new MariaDbEzasseExecutor());
        this.addExecutor(new HsqlDbExecutor());
    }
}

