/*
 * Decompiled with CFR 0.152.
 */
package cn.com.pism.ezasse;

import cn.com.pism.ezasse.executor.EzasseExecutor;
import cn.com.pism.ezasse.model.EzasseConfig;
import cn.com.pism.ezasse.model.EzasseSql;
import cn.com.pism.ezasse.util.EzasseIoUtil;
import cn.com.pism.ezasse.util.EzasseLogUtil;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EzasseGroupParser {
    private static final Log log = LogFactory.getLog(EzasseExecutor.class);
    private final LinkedHashMap<String, String> scriptMap = new LinkedHashMap();
    private final EzasseConfig config;
    private final EzasseSql sql;
    private final Set<String> checkKeyWord;

    public EzasseGroupParser(EzasseConfig config, EzasseSql sql, Set<String> checkKeyWord) {
        this.config = config;
        this.sql = sql;
        this.checkKeyWord = checkKeyWord;
    }

    LinkedHashMap<String, String> parser() {
        EzasseLogUtil.debug(log, "Ezasse - group parser path : " + this.sql.getPath());
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(this.sql.getPath());
        List<String> lines = EzasseIoUtil.readLines(inputStream);
        boolean isSqlBody = false;
        StringBuilder sqlLines = new StringBuilder();
        String checkLine = "";
        for (String line : lines) {
            boolean isEndLine;
            if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{this.config.getDelimiterStart(), this.config.getDelimiterEnd()})) {
                if (isSqlBody && !this.isCheckLine(line)) {
                    sqlLines.append(line).append("\n");
                }
                if (isSqlBody && this.isCheckLine(line)) {
                    isSqlBody = false;
                    this.scriptMap.put(checkLine, sqlLines.toString());
                    checkLine = "";
                    sqlLines = new StringBuilder();
                }
                if (this.isCheckLine(line)) {
                    isSqlBody = true;
                    checkLine = line.substring("--".length() + 1);
                }
            }
            if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.config.getDelimiterStart(), this.config.getDelimiterEnd()})) continue;
            boolean bl = isEndLine = isSqlBody && this.isCheckLine(line);
            if (line.startsWith(this.config.getDelimiterEnd()) || isEndLine) {
                isSqlBody = false;
                this.scriptMap.put(checkLine, sqlLines.toString());
                checkLine = "";
                sqlLines = new StringBuilder();
            }
            if (isSqlBody && !this.isCheckLine(line)) {
                sqlLines.append(line).append("\n");
            }
            if (this.isCheckLine(line)) {
                checkLine = line.substring("--".length() + 1);
            }
            if (!line.startsWith(this.config.getDelimiterStart()) || !StringUtils.isNotBlank((CharSequence)checkLine) || !StringUtils.isBlank((CharSequence)sqlLines.toString())) continue;
            isSqlBody = true;
        }
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{this.config.getDelimiterStart(), this.config.getDelimiterEnd()})) {
            this.scriptMap.put(checkLine, sqlLines.toString());
        }
        return this.scriptMap;
    }

    private boolean isCheckLine(String line) {
        if (line.startsWith("--")) {
            String checkLine = line.substring("--".length() + 1);
            return StringUtils.startsWithAny((CharSequence)checkLine, (CharSequence[])this.checkKeyWord.toArray(new String[0]));
        }
        return false;
    }
}

