/*
 * Decompiled with CFR 0.152.
 */
package cn.com.pism.ezasse.model;

import cn.com.pism.ezasse.enums.EzasseExceptionCode;
import cn.com.pism.ezasse.exception.EzasseException;
import cn.com.pism.ezasse.model.EzasseSql;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;

public class EzasseCheckNode {
    private DataSource checkNode;
    private DataSource execNode;
    private String checkKey;
    private String checkContent;

    public EzasseCheckNode(String checkLine, EzasseSql ezasseSql, Map<String, DataSource> dataSourceMap) {
        int startIndex = checkLine.indexOf("(");
        int endIndex = checkLine.lastIndexOf(")");
        String checkKeyStr = checkLine.substring(0, startIndex);
        this.checkContent = checkLine.substring(startIndex + 1, endIndex);
        String[] checkKeySplit = checkKeyStr.split("\\.");
        int checkLength = checkKeySplit.length;
        String defaultExecNode = ezasseSql.getNode();
        if (StringUtils.isBlank((CharSequence)defaultExecNode)) {
            defaultExecNode = "master";
        }
        switch (checkLength) {
            case 1: {
                this.checkKey = checkKeySplit[0];
                this.checkNode = dataSourceMap.get(defaultExecNode);
                this.execNode = dataSourceMap.get(defaultExecNode);
                break;
            }
            case 2: {
                this.checkKey = checkKeySplit[0];
                this.checkNode = dataSourceMap.get(checkKeySplit[1]);
                this.execNode = dataSourceMap.get(defaultExecNode);
                break;
            }
            case 3: {
                this.checkKey = checkKeySplit[0];
                this.checkNode = dataSourceMap.get(checkKeySplit[1]);
                this.execNode = dataSourceMap.get(checkKeySplit[2]);
                break;
            }
            default: {
                throw new EzasseException(EzasseExceptionCode.SYNTAX_ERROR_EXCEPTION);
            }
        }
    }

    public DataSource getCheckNode() {
        return this.checkNode;
    }

    public void setCheckNode(DataSource checkNode) {
        this.checkNode = checkNode;
    }

    public DataSource getExecNode() {
        return this.execNode;
    }

    public void setExecNode(DataSource execNode) {
        this.execNode = execNode;
    }

    public String getCheckKey() {
        return this.checkKey;
    }

    public void setCheckKey(String checkKey) {
        this.checkKey = checkKey;
    }

    public String getCheckContent() {
        return this.checkContent;
    }

    public void setCheckContent(String checkContent) {
        this.checkContent = checkContent;
    }
}

