/*
 * Decompiled with CFR 0.152.
 */
package cn.com.pism.ezasse.jdbc.action;

import cn.com.pism.ezasse.exception.EzasseException;
import cn.com.pism.ezasse.jdbc.action.JdbcTemplateCache;
import cn.com.pism.ezasse.jdbc.action.param.GetTableInfoActionParam;
import cn.com.pism.ezasse.model.EzasseDataSource;
import cn.com.pism.ezasse.model.EzasseExecutorAction;
import cn.com.pism.ezasse.model.EzasseTableInfo;
import cn.com.pism.ezasse.util.EzasseUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

public class JdbcGetTableInfoActionBuilder
implements EzasseExecutorAction<GetTableInfoActionParam, List<EzasseTableInfo>> {
    private final Map<String, String> selectMap = new HashMap<String, String>(16);
    private String from;
    private final Map<String, String> where = new HashMap<String, String>(16);
    private final Map<String, Function<WhereCondition, String>> paramWhere = new HashMap<String, Function<WhereCondition, String>>(16);

    private JdbcGetTableInfoActionBuilder() {
    }

    public static JdbcGetTableInfoActionBuilder builder() {
        return new JdbcGetTableInfoActionBuilder();
    }

    public List<EzasseTableInfo> doAction(GetTableInfoActionParam actionParam, EzasseDataSource dataSource) {
        SqlArgs sqlArgs = this.buildQuerySql(actionParam, dataSource);
        return EzasseUtil.toTableInfo((List)JdbcTemplateCache.get(dataSource.getId()).queryForList(sqlArgs.getSql(), sqlArgs.getArgs().toArray()));
    }

    private SqlArgs buildQuerySql(GetTableInfoActionParam actionParam, EzasseDataSource dataSource) {
        StringBuilder getTableInfoSql = new StringBuilder("select \n");
        this.appendSelect(getTableInfoSql);
        getTableInfoSql.append(" from ").append(this.from).append("\n");
        if (CollectionUtils.isEmpty(this.paramWhere) && CollectionUtils.isEmpty(this.where)) {
            return new SqlArgs(getTableInfoSql.toString(), null);
        }
        getTableInfoSql.append("where\n");
        ArrayList<String> wheres = new ArrayList<String>();
        ArrayList<String> args = new ArrayList<String>();
        WhereCondition whereCondition = new WhereCondition();
        whereCondition.setDataSource(dataSource);
        whereCondition.setActionParam(actionParam);
        this.appendParamWhere(whereCondition, args, wheres);
        this.appendWhere(args, wheres);
        getTableInfoSql.append(String.join((CharSequence)"AND ", wheres));
        return new SqlArgs(getTableInfoSql.toString(), args);
    }

    private void appendParamWhere(WhereCondition whereCondition, List<String> args, List<String> wheres) {
        List paramWhereList = this.paramWhere.entrySet().stream().map(entry -> {
            if (entry.getValue() == null || StringUtils.isBlank((CharSequence)((CharSequence)((Function)entry.getValue()).apply(whereCondition)))) {
                return "";
            }
            args.add((String)((Function)entry.getValue()).apply(whereCondition));
            return (String)entry.getKey() + " = ?\n";
        }).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(paramWhereList)) {
            wheres.addAll(paramWhereList);
        }
    }

    private void appendWhere(List<String> args, List<String> wheres) {
        List whereList = this.where.entrySet().stream().map(entry -> {
            if (StringUtils.isBlank((CharSequence)((CharSequence)entry.getValue()))) {
                return "";
            }
            args.add((String)entry.getValue());
            return (String)entry.getKey() + " = ?\n";
        }).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(wheres)) {
            wheres.addAll(whereList);
        }
    }

    private void appendSelect(StringBuilder getTableInfoSql) {
        getTableInfoSql.append(this.selectMap.entrySet().stream().map(entry -> (String)entry.getKey() + " " + (String)entry.getValue() + "\n").collect(Collectors.joining(",")));
    }

    public String getId() {
        return "getTableInfo";
    }

    public JdbcGetTableInfoActionBuilder select(String column, String as) {
        this.selectMap.put(column, as);
        return this;
    }

    public JdbcGetTableInfoActionBuilder selectColumnName(String selectColumnName) {
        this.selectMap.put(selectColumnName, "columnName");
        return this;
    }

    public JdbcGetTableInfoActionBuilder selectDataType(String selectDataType) {
        this.selectMap.put(selectDataType, "dataType");
        return this;
    }

    public JdbcGetTableInfoActionBuilder selectDataLength(String selectDataLength) {
        this.selectMap.put(selectDataLength, "dataLength");
        return this;
    }

    public JdbcGetTableInfoActionBuilder selectColumnComment(String selectColumnComment) {
        this.selectMap.put(selectColumnComment, "columnComment");
        return this;
    }

    public JdbcGetTableInfoActionBuilder from(String from) {
        this.from = from;
        return this;
    }

    public JdbcGetTableInfoActionBuilder where(String column, String condition) {
        this.where.put(column, condition);
        return this;
    }

    public JdbcGetTableInfoActionBuilder where(String column, Function<WhereCondition, String> condition) {
        this.paramWhere.put(column, condition);
        return this;
    }

    public JdbcGetTableInfoActionBuilder build() {
        if (CollectionUtils.isEmpty(this.selectMap)) {
            throw new EzasseException("selectMap empty error");
        }
        return this;
    }

    public static class WhereCondition {
        private EzasseDataSource dataSource;
        private GetTableInfoActionParam actionParam;

        @Generated
        public WhereCondition() {
        }

        @Generated
        public EzasseDataSource getDataSource() {
            return this.dataSource;
        }

        @Generated
        public GetTableInfoActionParam getActionParam() {
            return this.actionParam;
        }

        @Generated
        public void setDataSource(EzasseDataSource dataSource) {
            this.dataSource = dataSource;
        }

        @Generated
        public void setActionParam(GetTableInfoActionParam actionParam) {
            this.actionParam = actionParam;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WhereCondition)) {
                return false;
            }
            WhereCondition other = (WhereCondition)o;
            if (!other.canEqual(this)) {
                return false;
            }
            EzasseDataSource this$dataSource = this.getDataSource();
            EzasseDataSource other$dataSource = other.getDataSource();
            if (this$dataSource == null ? other$dataSource != null : !this$dataSource.equals(other$dataSource)) {
                return false;
            }
            GetTableInfoActionParam this$actionParam = this.getActionParam();
            GetTableInfoActionParam other$actionParam = other.getActionParam();
            return !(this$actionParam == null ? other$actionParam != null : !((Object)this$actionParam).equals(other$actionParam));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof WhereCondition;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            EzasseDataSource $dataSource = this.getDataSource();
            result = result * 59 + ($dataSource == null ? 43 : $dataSource.hashCode());
            GetTableInfoActionParam $actionParam = this.getActionParam();
            result = result * 59 + ($actionParam == null ? 43 : ((Object)$actionParam).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "JdbcGetTableInfoActionBuilder.WhereCondition(dataSource=" + this.getDataSource() + ", actionParam=" + this.getActionParam() + ")";
        }
    }

    private static class SqlArgs {
        private String sql;
        private List<String> args;

        @Generated
        public String getSql() {
            return this.sql;
        }

        @Generated
        public List<String> getArgs() {
            return this.args;
        }

        @Generated
        public void setSql(String sql) {
            this.sql = sql;
        }

        @Generated
        public void setArgs(List<String> args) {
            this.args = args;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SqlArgs)) {
                return false;
            }
            SqlArgs other = (SqlArgs)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$sql = this.getSql();
            String other$sql = other.getSql();
            if (this$sql == null ? other$sql != null : !this$sql.equals(other$sql)) {
                return false;
            }
            List<String> this$args = this.getArgs();
            List<String> other$args = other.getArgs();
            return !(this$args == null ? other$args != null : !((Object)this$args).equals(other$args));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SqlArgs;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $sql = this.getSql();
            result = result * 59 + ($sql == null ? 43 : $sql.hashCode());
            List<String> $args = this.getArgs();
            result = result * 59 + ($args == null ? 43 : ((Object)$args).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "JdbcGetTableInfoActionBuilder.SqlArgs(sql=" + this.getSql() + ", args=" + this.getArgs() + ")";
        }

        @Generated
        public SqlArgs(String sql, List<String> args) {
            this.sql = sql;
            this.args = args;
        }
    }
}

