/*
 * Decompiled with CFR 0.152.
 */
package cn.com.pism.ezasse.jdbc.action;

import cn.com.pism.ezasse.context.EzasseContextHolder;
import cn.com.pism.ezasse.model.EzasseDataSource;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.jdbc.core.JdbcTemplate;

public class JdbcTemplateCache {
    private static final Map<String, JdbcTemplate> JDBC_TEMPLATE_MAP = new HashMap<String, JdbcTemplate>(16);

    private JdbcTemplateCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JdbcTemplate get(String dataSourceId) {
        JdbcTemplate jdbcTemplate = JDBC_TEMPLATE_MAP.get(dataSourceId);
        if (jdbcTemplate != null) return jdbcTemplate;
        Class<EzasseDataSource> clazz = EzasseDataSource.class;
        synchronized (EzasseDataSource.class) {
            EzasseDataSource dataSource = EzasseContextHolder.getContext().datasourceManager().getDataSource(dataSourceId);
            jdbcTemplate = new JdbcTemplate((DataSource)dataSource.getDataSource());
            JDBC_TEMPLATE_MAP.put(dataSourceId, jdbcTemplate);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return jdbcTemplate;
        }
    }
}

