/*
 * Decompiled with CFR 0.152.
 */
package cn.com.pism.ezasse.jdbc.action.oracle;

import cn.com.pism.ezasse.jdbc.action.JdbcGetTableInfoAction;
import cn.com.pism.ezasse.jdbc.action.JdbcTemplateCache;
import cn.com.pism.ezasse.jdbc.action.param.GetTableInfoActionParam;
import cn.com.pism.ezasse.model.EzasseDataSource;
import cn.com.pism.ezasse.model.EzasseTableInfo;
import cn.com.pism.ezasse.util.EzasseUtil;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.jdbc.core.JdbcTemplate;

public class OracleGetTableInfoAction
extends JdbcGetTableInfoAction {
    private static final String GET_TABLE_INFO_SQL = "SELECT UTC.COLUMN_NAME columnName,\n       UTC.DATA_TYPE   dataType,\n       UTC.CHAR_LENGTH dataLength,\n       UCC.COMMENTS    columnComment\nFROM USER_TAB_COLS UTC\n         LEFT JOIN USER_COL_COMMENTS UCC ON UTC.TABLE_NAME = UCC.TABLE_NAME AND UTC.COLUMN_NAME = UCC.COLUMN_NAME\nWHERE UTC.TABLE_NAME = ?\n";
    private static final String COLUMN_NAME_FILTER = "AND UTC.COLUMN_NAME = ?";

    public List<EzasseTableInfo> doAction(GetTableInfoActionParam actionParam, EzasseDataSource dataSource) {
        JdbcTemplate jdbcTemplate = JdbcTemplateCache.get(dataSource.getId());
        List tableInfos = StringUtils.isNotBlank((CharSequence)actionParam.getColumnName()) ? jdbcTemplate.queryForList("SELECT UTC.COLUMN_NAME columnName,\n       UTC.DATA_TYPE   dataType,\n       UTC.CHAR_LENGTH dataLength,\n       UCC.COMMENTS    columnComment\nFROM USER_TAB_COLS UTC\n         LEFT JOIN USER_COL_COMMENTS UCC ON UTC.TABLE_NAME = UCC.TABLE_NAME AND UTC.COLUMN_NAME = UCC.COLUMN_NAME\nWHERE UTC.TABLE_NAME = ?\nAND UTC.COLUMN_NAME = ?", new Object[]{actionParam.getTableName(), actionParam.getColumnName()}) : jdbcTemplate.queryForList(GET_TABLE_INFO_SQL, new Object[]{actionParam.getTableName()});
        return EzasseUtil.toTableInfo((List)tableInfos);
    }
}

