/*
 * Decompiled with CFR 0.152.
 */
package cn.com.pism.ezasse.jdbc.checker.change;

import cn.com.pism.ezasse.checker.EzasseChecker;
import cn.com.pism.ezasse.jdbc.action.param.GetTableInfoActionParam;
import cn.com.pism.ezasse.model.ActionParam;
import cn.com.pism.ezasse.model.EzasseDataSource;
import cn.com.pism.ezasse.model.EzasseTableInfo;
import cn.com.pism.ezasse.util.EzasseUtil;
import cn.com.pism.ezasse.util.IterableUtils;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

public abstract class ChangeFieldChecker
extends EzasseChecker {
    public boolean check(EzasseDataSource dataSource, String checkContent) {
        String[] split = checkContent.split("\\.");
        if (!this.isSyntaxValid(checkContent)) {
            return false;
        }
        if (!this.isSyntaxValid(split)) {
            return false;
        }
        List tableInfos = (List)this.getEzasseExecutor(dataSource).execute("getTableInfo", (ActionParam)GetTableInfoActionParam.builder().tableName(split[0]).columnName(split[1]).build(), dataSource);
        if (CollectionUtils.isEmpty((Collection)tableInfos)) {
            return false;
        }
        if (this.checkTableFieldExists(dataSource, checkContent)) {
            EzasseTableInfo tableInfo = (EzasseTableInfo)IterableUtils.find((Iterable)tableInfos, info -> info.getColumnName().equals(split[1]));
            if (tableInfo == null) {
                return false;
            }
            return this.doChangeFieldCheck(tableInfo, split[0], split[1], EzasseUtil.removeBeforeNthOccurrence((String)checkContent, (char)'.', (int)2));
        }
        return this.doChangeFieldCheck(tableInfos, split[0], split[1]);
    }

    protected boolean isSyntaxValid(String checkContent) {
        return StringUtils.isNotBlank((CharSequence)checkContent);
    }

    protected boolean checkTableFieldExists() {
        return true;
    }

    protected boolean checkTableFieldExists(EzasseDataSource dataSource, String checkContent) {
        return this.checkTableFieldExists();
    }

    protected boolean isSyntaxValid(String[] split) {
        return split.length >= 3;
    }

    protected boolean doChangeFieldCheck(EzasseTableInfo tableInfo, String tableName, String field, String targetValue) {
        return false;
    }

    protected boolean doChangeFieldCheck(List<EzasseTableInfo> tableInfos, String tableName, String field) {
        return false;
    }
}

