/*
 * Decompiled with CFR 0.152.
 */
package cn.com.pism.ezasse.jdbc.checker.change;

import cn.com.pism.ezasse.context.EzasseContextHolder;
import cn.com.pism.ezasse.jdbc.checker.change.ChangeFieldChecker;
import cn.com.pism.ezasse.model.EzasseDataSource;
import cn.com.pism.ezasse.model.EzasseTableInfo;
import cn.com.pism.ezasse.util.IterableUtils;
import java.util.List;

public class ChangeFieldNameChecker
extends ChangeFieldChecker {
    @Override
    protected boolean doChangeFieldCheck(List<EzasseTableInfo> tableInfos, String tableName, String field) {
        return IterableUtils.find(tableInfos, info -> info.getColumnName().equals(field)) != null;
    }

    @Override
    protected boolean doChangeFieldCheck(EzasseTableInfo tableInfo, String tableName, String field, String targetValue) {
        return !targetValue.equals(field);
    }

    @Override
    protected boolean checkTableFieldExists(EzasseDataSource dataSource, String checkContent) {
        String[] split = checkContent.split("\\.");
        return split.length > 2;
    }

    @Override
    protected boolean isSyntaxValid(String[] split) {
        return split.length >= 2;
    }

    public String getId() {
        return EzasseContextHolder.getContext().configManager().getConfig().getKeyWords().getField().getChangeName();
    }
}

