/*
 * Decompiled with CFR 0.152.
 */
package cn.com.pism.ezasse.jdbc.register;

import cn.com.pism.ezasse.model.EzasseDataSource;
import java.sql.Connection;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JdbcEzasseDataSource
implements EzasseDataSource {
    private static final Log log = LogFactory.getLog(JdbcEzasseDataSource.class);
    private DataSource dataSource;
    private String id;

    public <T> T getDataSource() {
        return (T)this.dataSource;
    }

    public String getId() {
        return this.id;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getType() {
        try (Connection connection = this.dataSource.getConnection();){
            String string = this.getDatabaseProductName(connection.getMetaData().getURL()).toUpperCase();
            return string;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return "UNKNOWN";
        }
    }

    private String getDatabaseProductName(String jdbcUrl) {
        if (jdbcUrl == null || jdbcUrl.isEmpty()) {
            return "UNKNOWN";
        }
        if (!jdbcUrl.startsWith("jdbc:")) {
            return "UNKNOWN";
        }
        String remaining = jdbcUrl.substring(5);
        int index = remaining.indexOf(58);
        if (index != -1) {
            return remaining.substring(0, index);
        }
        index = remaining.indexOf(47);
        if (index != -1) {
            return remaining.substring(0, index);
        }
        return remaining;
    }

    @Generated
    public JdbcEzasseDataSource(DataSource dataSource, String id) {
        this.dataSource = dataSource;
        this.id = id;
    }
}

