/*
 * Decompiled with CFR 0.152.
 */
package cn.com.pism.ezasse;

import cn.com.pism.ezasse.model.EzasseConfig;
import cn.com.pism.ezasse.model.EzasseSql;
import cn.hutool.core.io.FileUtil;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class EzasseGroupParser {
    LinkedHashMap<String, String> scriptMap = new LinkedHashMap();
    EzasseConfig config;
    EzasseSql sql;

    public EzasseGroupParser(EzasseConfig config, EzasseSql sql) {
        this.config = config;
        this.sql = sql;
    }

    LinkedHashMap<String, String> parser() {
        List lines = FileUtil.readLines((String)this.sql.getPath(), (Charset)StandardCharsets.UTF_8);
        boolean isSqlBody = false;
        StringBuilder sqlLines = new StringBuilder();
        String checkLine = "";
        for (String line : lines) {
            boolean isEndLine;
            if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{this.config.getDelimiterStart(), this.config.getDelimiterEnd()})) {
                if (isSqlBody && !this.isCheckLine(line)) {
                    sqlLines.append(line).append("\n");
                }
                if (isSqlBody && this.isCheckLine(line)) {
                    isSqlBody = false;
                    this.scriptMap.put(checkLine, sqlLines.toString());
                    checkLine = "";
                    sqlLines = new StringBuilder();
                }
                if (this.isCheckLine(line)) {
                    isSqlBody = true;
                    checkLine = line.substring("--".length() + 1);
                }
            }
            if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.config.getDelimiterStart(), this.config.getDelimiterEnd()})) continue;
            boolean bl = isEndLine = isSqlBody && this.isCheckLine(line);
            if (line.startsWith(this.config.getDelimiterEnd()) || isEndLine) {
                isSqlBody = false;
                this.scriptMap.put(checkLine, sqlLines.toString());
                checkLine = "";
                sqlLines = new StringBuilder();
            }
            if (isSqlBody && !this.isCheckLine(line)) {
                sqlLines.append(line).append("\n");
            }
            if (this.isCheckLine(line)) {
                checkLine = line.substring("--".length() + 1);
            }
            if (!line.startsWith(this.config.getDelimiterStart()) || !StringUtils.isNotBlank((CharSequence)checkLine) || !StringUtils.isBlank((CharSequence)sqlLines.toString())) continue;
            isSqlBody = true;
        }
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{this.config.getDelimiterStart(), this.config.getDelimiterEnd()})) {
            this.scriptMap.put(checkLine, sqlLines.toString());
        }
        return this.scriptMap;
    }

    private boolean isCheckLine(String line) {
        if (line.startsWith("--")) {
            String checkLine = line.substring("--".length() + 1);
            return StringUtils.startsWithAny((CharSequence)checkLine, (CharSequence[])new CharSequence[]{this.config.getTable(), this.config.getChange(), this.config.getDefaultKeyWord()});
        }
        return false;
    }
}

