/*
 * Decompiled with CFR 0.152.
 */
package cn.com.pism.ezasse.executor;

import cn.com.pism.ezasse.model.EzasseTableInfo;
import cn.com.pism.ezasse.util.EzasseUtil;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;

public abstract class EzasseExecutor {
    private static final Logger log = LoggerFactory.getLogger(EzasseExecutor.class);
    protected JdbcTemplate jdbcTemplate;
    protected DataSource dataSource;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    public <T> T queryForObject(String sql, Class<T> clazz) {
        return (T)this.jdbcTemplate.queryForObject(sql, clazz);
    }

    public <T> List<T> queryForList(Class<T> clazz, String sql, Objects ... args) {
        return this.jdbcTemplate.queryForList(sql, clazz, (Object[])args);
    }

    public abstract List<EzasseTableInfo> getTableInfo(String var1, String var2);

    public abstract List<EzasseTableInfo> getTableInfo(String var1);

    public void execute(String sql) {
        this.jdbcTemplate.execute(sql);
    }

    protected static String getDataBaseNameFromDataSource(DataSource dataSource) {
        String catalog = EzasseUtil.getFromDataSource(dataSource, connection -> {
            try {
                return connection.getCatalog();
            }
            catch (SQLException e) {
                log.error(e.getMessage());
                return "";
            }
        });
        if (StringUtils.isBlank((CharSequence)catalog)) {
            return "";
        }
        return catalog;
    }

    public abstract String getId();
}

