/*
 * Decompiled with CFR 0.152.
 */
package cn.com.pism.ezasse.model;

import cn.com.pism.ezasse.enums.EzasseExceptionCode;
import cn.com.pism.ezasse.exception.EzasseException;
import cn.com.pism.ezasse.model.EzasseSql;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;

public class EzasseCheckNode {
    private DataSource checkNode;
    private DataSource execNode;
    private String checkKey;
    private String checkContent;

    public EzasseCheckNode(String checkLine, EzasseSql ezasseSql, Map<String, DataSource> dataSourceMap) {
        int startIndex = checkLine.indexOf("(");
        int endIndex = checkLine.lastIndexOf(")");
        String checkKeyStr = checkLine.substring(0, startIndex);
        this.checkContent = checkLine.substring(startIndex + 1, endIndex);
        String[] checkKeySplit = checkKeyStr.split("\\.");
        int checkLength = checkKeySplit.length;
        String defaultExecNode = ezasseSql.getNode();
        if (StringUtils.isBlank((CharSequence)defaultExecNode)) {
            defaultExecNode = "master";
        }
        switch (checkLength) {
            case 1: {
                this.checkKey = checkKeySplit[0];
                this.checkNode = dataSourceMap.get(defaultExecNode);
                this.execNode = dataSourceMap.get(defaultExecNode);
                break;
            }
            case 2: {
                this.checkKey = checkKeySplit[0];
                this.checkNode = dataSourceMap.get(checkKeySplit[1]);
                this.execNode = dataSourceMap.get(defaultExecNode);
                break;
            }
            case 3: {
                this.checkKey = checkKeySplit[0];
                this.checkNode = dataSourceMap.get(checkKeySplit[1]);
                this.execNode = dataSourceMap.get(checkKeySplit[2]);
                break;
            }
            default: {
                throw new EzasseException(EzasseExceptionCode.SYNTAX_ERROR_EXCEPTION);
            }
        }
    }

    public DataSource getCheckNode() {
        return this.checkNode;
    }

    public DataSource getExecNode() {
        return this.execNode;
    }

    public String getCheckKey() {
        return this.checkKey;
    }

    public String getCheckContent() {
        return this.checkContent;
    }

    public void setCheckNode(DataSource checkNode) {
        this.checkNode = checkNode;
    }

    public void setExecNode(DataSource execNode) {
        this.execNode = execNode;
    }

    public void setCheckKey(String checkKey) {
        this.checkKey = checkKey;
    }

    public void setCheckContent(String checkContent) {
        this.checkContent = checkContent;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EzasseCheckNode)) {
            return false;
        }
        EzasseCheckNode other = (EzasseCheckNode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DataSource this$checkNode = this.getCheckNode();
        DataSource other$checkNode = other.getCheckNode();
        if (this$checkNode == null ? other$checkNode != null : !this$checkNode.equals(other$checkNode)) {
            return false;
        }
        DataSource this$execNode = this.getExecNode();
        DataSource other$execNode = other.getExecNode();
        if (this$execNode == null ? other$execNode != null : !this$execNode.equals(other$execNode)) {
            return false;
        }
        String this$checkKey = this.getCheckKey();
        String other$checkKey = other.getCheckKey();
        if (this$checkKey == null ? other$checkKey != null : !this$checkKey.equals(other$checkKey)) {
            return false;
        }
        String this$checkContent = this.getCheckContent();
        String other$checkContent = other.getCheckContent();
        return !(this$checkContent == null ? other$checkContent != null : !this$checkContent.equals(other$checkContent));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EzasseCheckNode;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DataSource $checkNode = this.getCheckNode();
        result = result * 59 + ($checkNode == null ? 43 : $checkNode.hashCode());
        DataSource $execNode = this.getExecNode();
        result = result * 59 + ($execNode == null ? 43 : $execNode.hashCode());
        String $checkKey = this.getCheckKey();
        result = result * 59 + ($checkKey == null ? 43 : $checkKey.hashCode());
        String $checkContent = this.getCheckContent();
        result = result * 59 + ($checkContent == null ? 43 : $checkContent.hashCode());
        return result;
    }

    public String toString() {
        return "EzasseCheckNode(checkNode=" + this.getCheckNode() + ", execNode=" + this.getExecNode() + ", checkKey=" + this.getCheckKey() + ", checkContent=" + this.getCheckContent() + ")";
    }
}

