/*
 * Decompiled with CFR 0.152.
 */
package cn.com.pism.ezasse.starter;

import cn.com.pism.ezasse.Ezasse;
import cn.com.pism.ezasse.checker.EzasseChecker;
import cn.com.pism.ezasse.executor.EzasseExecutor;
import cn.com.pism.ezasse.model.EzasseConfig;
import cn.com.pism.ezasse.starter.EzasseDatasource;
import cn.com.pism.ezasse.starter.EzasseProperties;
import com.alibaba.fastjson2.JSON;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.JdbcTemplateAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.JdbcTemplate;

@Configuration
@ConditionalOnClass(value={Ezasse.class})
@EnableConfigurationProperties(value={EzasseProperties.class})
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class, JdbcTemplateAutoConfiguration.class})
public class EzasseConfiguration
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(EzasseConfiguration.class);
    private ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Bean
    @ConditionalOnMissingBean
    public Ezasse init() {
        log.info("Ezasse - Starting...");
        Ezasse ezasse = new Ezasse();
        EzasseProperties ezasseProperties = (EzasseProperties)this.applicationContext.getBean(EzasseProperties.class);
        EzasseConfig ezasseConfig = (EzasseConfig)JSON.parseObject((String)JSON.toJSONString((Object)ezasseProperties), EzasseConfig.class);
        ezasse.setConfig(ezasseConfig);
        ezasse.initChecker();
        Map ezasseCheckerMap = this.applicationContext.getBeansOfType(EzasseChecker.class);
        ezasseCheckerMap.forEach((s, ezasseChecker) -> {
            log.info("Ezasse - Add custom Checker :{}", (Object)ezasseChecker.getId(ezasseConfig));
            ezasse.addChecker(ezasseChecker);
        });
        Map ezasseExecutorMap = this.applicationContext.getBeansOfType(EzasseExecutor.class);
        ezasseExecutorMap.forEach((s, ezasseExecutor) -> {
            log.info("Ezasse - Add custom Executor :{}", (Object)ezasseExecutor.getId());
            ezasse.addExecutor(ezasseExecutor);
        });
        Object[] ezDatasource = this.applicationContext.getBeanNamesForType(EzasseDatasource.class);
        if (ArrayUtils.isNotEmpty((Object[])ezDatasource)) {
            EzasseDatasource ezasseDatasource = (EzasseDatasource)this.applicationContext.getBean((String)ezDatasource[0], EzasseDatasource.class);
            ezasseDatasource.getDataSource().forEach((arg_0, arg_1) -> ((Ezasse)ezasse).addDataSource(arg_0, arg_1));
            if (ezasseDatasource.getMaster() != null) {
                ezasse.setMaster(ezasseDatasource.getMaster());
            }
        } else {
            JdbcTemplate jdbcTemplate = (JdbcTemplate)this.applicationContext.getBean(JdbcTemplate.class);
            ezasse.setMaster(jdbcTemplate.getDataSource());
        }
        ezasse.executeScript();
        return ezasse;
    }
}

