/*
 * Decompiled with CFR 0.152.
 */
package cn.com.pism.frc.resourcescanner;

import cn.com.pism.frc.resourcescanner.ClassPathScanner;
import cn.com.pism.frc.resourcescanner.ClassProvider;
import cn.com.pism.frc.resourcescanner.JavaMigration;
import cn.com.pism.frc.resourcescanner.LoadableResource;
import cn.com.pism.frc.resourcescanner.Location;
import cn.com.pism.frc.resourcescanner.LocationScannerCache;
import cn.com.pism.frc.resourcescanner.ResourceNameCache;
import cn.com.pism.frc.resourcescanner.ResourceProvider;
import cn.com.pism.frc.resourcescanner.utils.StringUtils;
import com.alibaba.fastjson.JSON;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Scanner<I>
implements ResourceProvider,
ClassProvider<I> {
    private static final Logger log = LoggerFactory.getLogger(Scanner.class);
    private final List<LoadableResource> resources = new ArrayList<LoadableResource>();
    private final List<Class<? extends I>> classes = new ArrayList<Class<? extends I>>();
    private final HashMap<String, LoadableResource> relativeResourceMap = new HashMap();
    private HashMap<String, LoadableResource> absoluteResourceMap = null;

    public Scanner(Class<I> implementedInterface, Collection<Location> locations, ClassLoader classLoader, Charset encoding, ResourceNameCache resourceNameCache, LocationScannerCache locationScannerCache) {
        for (Location location : locations) {
            ClassPathScanner<I> resourceAndClassScanner = new ClassPathScanner<I>(implementedInterface, classLoader, encoding, location, resourceNameCache, locationScannerCache);
            this.resources.addAll(resourceAndClassScanner.scanForResources());
            this.classes.addAll(resourceAndClassScanner.scanForClasses());
        }
        for (LoadableResource resource : this.resources) {
            this.relativeResourceMap.put(resource.getRelativePath().toLowerCase(), resource);
        }
    }

    @Override
    public LoadableResource getResource(String name) {
        LoadableResource loadedResource = this.relativeResourceMap.get(name.toLowerCase());
        if (loadedResource != null) {
            return loadedResource;
        }
        if (Paths.get(name, new String[0]).isAbsolute()) {
            if (this.absoluteResourceMap == null) {
                this.absoluteResourceMap = new HashMap();
                for (LoadableResource resource : this.resources) {
                    this.absoluteResourceMap.put(resource.getAbsolutePathOnDisk().toLowerCase(), resource);
                }
            }
            if ((loadedResource = this.absoluteResourceMap.get(name.toLowerCase())) != null) {
                return loadedResource;
            }
        }
        return null;
    }

    @Override
    public Collection<LoadableResource> getResources(String prefix, String ... suffixes) {
        ArrayList<LoadableResource> result = new ArrayList<LoadableResource>();
        for (LoadableResource resource : this.resources) {
            String fileName = resource.getFilename();
            if (StringUtils.startsAndEndsWith(fileName, prefix, suffixes)) {
                result.add(resource);
                continue;
            }
            log.debug("Filtering out resource: " + resource.getAbsolutePath() + " (filename: " + fileName + ")");
        }
        return result;
    }

    @Override
    public Collection<Class<? extends I>> getClasses() {
        return Collections.unmodifiableCollection(this.classes);
    }

    public static void main(String[] args) {
        Scanner<JavaMigration> scanner = new Scanner<JavaMigration>(JavaMigration.class, Arrays.asList(new Location("classpath:sqls")), Thread.currentThread().getContextClassLoader(), StandardCharsets.UTF_8, new ResourceNameCache(), new LocationScannerCache());
        for (LoadableResource resource : scanner.resources) {
            System.out.println(JSON.toJSONString((Object)resource));
        }
    }
}

