/*
 * Decompiled with CFR 0.152.
 */
package cn.com.pism.frc.resourcescanner;

import cn.com.pism.frc.resourcescanner.exception.ScannerException;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Location
implements Comparable<Location> {
    private static final Logger log = LoggerFactory.getLogger(Location.class);
    private static final String CLASSPATH_PREFIX = "classpath:";
    public static final String FILESYSTEM_PREFIX = "filesystem:";
    private final String prefix;
    private String rawPath;
    private String rootPath;
    private Pattern pathRegex = null;

    public Location(String descriptor) {
        String normalizedDescriptor = descriptor.trim();
        if (normalizedDescriptor.contains(":")) {
            this.prefix = normalizedDescriptor.substring(0, normalizedDescriptor.indexOf(":") + 1);
            this.rawPath = normalizedDescriptor.substring(normalizedDescriptor.indexOf(":") + 1);
        } else {
            this.prefix = CLASSPATH_PREFIX;
            this.rawPath = normalizedDescriptor;
        }
        if (this.isClassPath()) {
            if (this.rawPath.contains(".")) {
                log.warn("Use of dots (.) as path separators will be deprecated in Flyway 7. Path: " + this.rawPath);
            }
            this.rawPath = this.rawPath.replace(".", "/");
            if (this.rawPath.startsWith("/")) {
                this.rawPath = this.rawPath.substring(1);
            }
            if (this.rawPath.endsWith("/")) {
                this.rawPath = this.rawPath.substring(0, this.rawPath.length() - 1);
            }
            this.processRawPath();
        } else if (this.isFileSystem()) {
            this.processRawPath();
            this.rootPath = new File(this.rootPath).getPath();
            if (this.pathRegex == null) {
                this.rawPath = new File(this.rawPath).getPath();
            }
        } else {
            throw new ScannerException("Unknown prefix for location (should be either filesystem: or classpath:): " + normalizedDescriptor);
        }
        if (this.rawPath.endsWith(File.separator)) {
            this.rawPath = this.rawPath.substring(0, this.rawPath.length() - 1);
        }
    }

    private void processRawPath() {
        if (this.rawPath.contains("*") || this.rawPath.contains("?")) {
            String seperator = this.isFileSystem() ? File.separator : "/";
            String escapedSeperator = seperator.replace("\\", "\\\\").replace("/", "\\/");
            String[] pathSplit = this.rawPath.split("[\\\\/]");
            StringBuilder rootPart = new StringBuilder();
            StringBuilder patternPart = new StringBuilder();
            boolean endsInFile = false;
            boolean skipSeperator = false;
            boolean inPattern = false;
            for (String pathPart : pathSplit) {
                endsInFile = false;
                if (pathPart.contains("*") || pathPart.contains("?")) {
                    inPattern = true;
                }
                if (inPattern) {
                    String regex;
                    if (skipSeperator) {
                        skipSeperator = false;
                    } else {
                        patternPart.append("/");
                    }
                    if ("**".equals(pathPart)) {
                        regex = "([^/]+/)*?";
                        skipSeperator = true;
                    } else {
                        endsInFile = pathPart.contains(".");
                        regex = pathPart;
                        regex = regex.replace(".", "\\.");
                        regex = regex.replace("?", "[^/]");
                        regex = regex.replace("*", "[^/]+?");
                    }
                    patternPart.append(regex);
                    continue;
                }
                rootPart.append(seperator).append(pathPart);
            }
            this.rootPath = rootPart.length() > 0 ? rootPart.toString().substring(1) : "";
            String pattern = patternPart.toString().substring(1);
            pattern = pattern.replace("/", escapedSeperator);
            if (rootPart.length() > 0) {
                pattern = this.rootPath.replace(seperator, escapedSeperator) + escapedSeperator + pattern;
            }
            if (!endsInFile) {
                pattern = pattern + escapedSeperator + "(?<relpath>.*)";
            }
            this.pathRegex = Pattern.compile(pattern);
        } else {
            this.rootPath = this.rawPath;
        }
    }

    public boolean matchesPath(String path) {
        if (this.pathRegex == null) {
            return true;
        }
        return this.pathRegex.matcher(path).matches();
    }

    public String getPathRelativeToThis(String path) {
        String relPath;
        Matcher matcher;
        if (this.pathRegex != null && this.pathRegex.pattern().contains("?<relpath>") && (matcher = this.pathRegex.matcher(path)).matches() && (relPath = matcher.group("relpath")) != null && relPath.length() > 0) {
            return relPath;
        }
        return this.rootPath.length() > 0 ? path.substring(this.rootPath.length() + 1) : path;
    }

    public boolean isClassPath() {
        return CLASSPATH_PREFIX.equals(this.prefix);
    }

    public boolean isFileSystem() {
        return FILESYSTEM_PREFIX.equals(this.prefix);
    }

    public boolean isParentOf(Location other) {
        if (this.pathRegex != null || other.pathRegex != null) {
            return false;
        }
        if (this.isClassPath() && other.isClassPath()) {
            return (other.getDescriptor() + "/").startsWith(this.getDescriptor() + "/");
        }
        if (this.isFileSystem() && other.isFileSystem()) {
            return (other.getDescriptor() + File.separator).startsWith(this.getDescriptor() + File.separator);
        }
        return false;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getRootPath() {
        return this.rootPath;
    }

    public String getPath() {
        return this.rawPath;
    }

    public Pattern getPathRegex() {
        return this.pathRegex;
    }

    public String getDescriptor() {
        return this.prefix + this.rawPath;
    }

    @Override
    public int compareTo(Location o) {
        return this.getDescriptor().compareTo(o.getDescriptor());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Location location = (Location)o;
        return this.getDescriptor().equals(location.getDescriptor());
    }

    public int hashCode() {
        return this.getDescriptor().hashCode();
    }

    public String toString() {
        return this.getDescriptor();
    }
}

