/*
 * Decompiled with CFR 0.152.
 */
package cn.com.pism.frc.resourcescanner;

import cn.com.pism.frc.resourcescanner.ClassPathLocationScanner;
import cn.com.pism.frc.resourcescanner.utils.UrlUtils;
import java.io.File;
import java.net.URL;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemClassPathLocationScanner
implements ClassPathLocationScanner {
    private static final Logger log = LoggerFactory.getLogger(FileSystemClassPathLocationScanner.class);

    @Override
    public Set<String> findResourceNames(String location, URL locationUrl) {
        String filePath = UrlUtils.toFilePath(locationUrl);
        File folder = new File(filePath);
        if (!folder.isDirectory()) {
            log.debug("Skipping path as it is not a directory: " + filePath);
            return new TreeSet<String>();
        }
        String classPathRootOnDisk = filePath.substring(0, filePath.length() - location.length());
        if (!classPathRootOnDisk.endsWith(File.separator)) {
            classPathRootOnDisk = classPathRootOnDisk + File.separator;
        }
        log.debug("Scanning starting at classpath root in filesystem: " + classPathRootOnDisk);
        return this.findResourceNamesFromFileSystem(classPathRootOnDisk, location, folder);
    }

    Set<String> findResourceNamesFromFileSystem(String classPathRootOnDisk, String scanRootLocation, File folder) {
        File[] files;
        log.debug("Scanning for resources in path: " + folder.getPath() + " (" + scanRootLocation + ")");
        TreeSet<String> resourceNames = new TreeSet<String>();
        for (File file : files = folder.listFiles()) {
            if (!file.canRead()) continue;
            if (file.isDirectory()) {
                resourceNames.addAll(this.findResourceNamesFromFileSystem(classPathRootOnDisk, scanRootLocation, file));
                continue;
            }
            resourceNames.add(this.toResourceNameOnClasspath(classPathRootOnDisk, file));
        }
        return resourceNames;
    }

    private String toResourceNameOnClasspath(String classPathRootOnDisk, File file) {
        String fileName = file.getAbsolutePath().replace("\\", "/");
        return fileName.substring(classPathRootOnDisk.length());
    }
}

