/*
 * Decompiled with CFR 0.152.
 */
package cn.com.pism.gfd;

import cn.com.pism.gfd.enums.ActionEnum;
import cn.com.pism.gfd.exception.GoFastDfsException;
import cn.com.pism.gfd.model.config.GoFastDfsConfig;
import cn.com.pism.gfd.model.params.Reload;
import cn.com.pism.gfd.model.params.Upload;
import cn.com.pism.gfd.model.result.GetFileInfoResult;
import cn.com.pism.gfd.model.result.GoFastDfsResult;
import cn.com.pism.gfd.model.result.ListDirResult;
import cn.com.pism.gfd.model.result.StatResult;
import cn.com.pism.gfd.model.result.UploadResult;
import cn.com.pism.gfd.properties.GoFastDfsProperties;
import cn.com.pism.gfd.util.ObjectToBeanUtil;
import cn.hutool.core.io.resource.InputStreamResource;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoFastDfsUtil {
    private static final Logger log = LoggerFactory.getLogger(GoFastDfsUtil.class);
    private GoFastDfsProperties properties;

    public String getBaseUrl() {
        String group = this.properties.getGroup();
        if (StringUtils.isNotBlank((CharSequence)group)) {
            group = group + "/";
        }
        return "http://" + this.properties.getIp() + ":" + this.properties.getPort() + "/" + group;
    }

    public GoFastDfsConfig reload(ActionEnum action, ReloadAction reloadAction) {
        Reload reload = new Reload();
        GoFastDfsConfig getConfig = null;
        if (action != ActionEnum.RELOAD) {
            getConfig = this.post("reload", reload.setAction(ActionEnum.GET), GoFastDfsConfig.class);
        }
        switch (action) {
            case GET: {
                return getConfig;
            }
            case SET: {
                reloadAction.setConfig(getConfig);
                reload.setAction(ActionEnum.SET).setCfg(getConfig);
                this.post("reload", reload, GoFastDfsConfig.class);
                break;
            }
            case RELOAD: {
                reload.setAction(ActionEnum.RELOAD);
                this.post("reload", reload, GoFastDfsConfig.class);
                break;
            }
        }
        getConfig = this.post("reload", reload.setAction(ActionEnum.GET), GoFastDfsConfig.class);
        return getConfig;
    }

    public List<StatResult> stat() {
        return this.postToArr("stat", null, StatResult.class);
    }

    public UploadResult upload(Upload upload) {
        return this.postUpload(upload);
    }

    public void deleteByMd5(String md5) {
        HashMap<String, Object> map = new HashMap<String, Object>(0);
        map.put("md5", md5);
        this.post(this.getBaseUrl() + "delete", map);
    }

    public void deleteByPath(String path) {
        HashMap<String, Object> map = new HashMap<String, Object>(0);
        map.put("path", path);
        this.post(this.getBaseUrl() + "delete", map);
    }

    public GetFileInfoResult getFileInfoByMd5(String md5) {
        HashMap<String, String> map = new HashMap<String, String>(0);
        map.put("md5", md5);
        return this.post("get_file_info", map, GetFileInfoResult.class);
    }

    public GetFileInfoResult getFileInfoByPath(String path) {
        HashMap<String, String> map = new HashMap<String, String>(0);
        map.put("path", path);
        return this.post("get_file_info", map, GetFileInfoResult.class);
    }

    public List<ListDirResult> listDirResult(String dir) {
        HashMap<String, String> map = new HashMap<String, String>(0);
        map.put("dir", dir);
        return this.postToArr("list_dir", map, ListDirResult.class);
    }

    public void repairStat(String date) {
        HashMap<String, Object> map = new HashMap<String, Object>(0);
        map.put("date", date);
        this.post(this.getBaseUrl() + "repair_stat", map);
    }

    public void repair(boolean force) {
        HashMap<String, Object> map = new HashMap<String, Object>(0);
        map.put("force", force ? 1 : 0);
        this.post(this.getBaseUrl() + "repair", map);
    }

    public void repairFileInfo() {
        this.reload(ActionEnum.SET, config -> config.setEnableMigrate(Boolean.TRUE));
        this.post(this.getBaseUrl() + "repair_fileinfo", null);
    }

    public <T> T post(String url, Object params, Class<T> clazz) {
        String res = this.getPostResult(url, params);
        return this.parseResToObj(clazz, res);
    }

    public UploadResult postUpload(Upload upload) {
        try {
            String md5;
            String authToken;
            String code;
            String filename;
            String scene;
            HashMap<String, Object> params = new HashMap<String, Object>(0);
            File file = upload.getFile();
            if (file != null) {
                InputStreamResource isr = new InputStreamResource((InputStream)new FileInputStream(file), file.getName());
                params.put("file", isr);
            }
            if (StringUtils.isNotBlank((CharSequence)(scene = upload.getScene()))) {
                params.put("scene", scene);
            }
            if (StringUtils.isNotBlank((CharSequence)(filename = upload.getFilename()))) {
                params.put("filename", filename);
            }
            params.put("output", "json2");
            String path = upload.getPath();
            if (StringUtils.isNotBlank((CharSequence)path)) {
                params.put("path", path);
            }
            if (StringUtils.isNotBlank((CharSequence)(code = upload.getCode()))) {
                params.put("code", code);
            }
            if (StringUtils.isNotBlank((CharSequence)(authToken = upload.getAuthToken()))) {
                params.put("auth_token", authToken);
            }
            if (StringUtils.isNotBlank((CharSequence)(md5 = upload.getMd5()))) {
                params.put("md5", md5);
            }
            String res = this.post(this.getBaseUrl() + "upload", params);
            return this.parseResToObj(UploadResult.class, res);
        }
        catch (FileNotFoundException e) {
            log.error(e.getMessage());
            return new UploadResult();
        }
    }

    private <T> T parseResToObj(Class<T> clazz, String res) {
        GoFastDfsResult result = (GoFastDfsResult)JSON.parseObject((String)res, (TypeReference)new TypeReference<GoFastDfsResult<Object>>(){}, (Feature[])new Feature[0]);
        String status = result.getStatus();
        if ("ok".equals(status)) {
            return ObjectToBeanUtil.parse(result.getData(), clazz);
        }
        log.error("error result:{}", result.getData());
        log.error("error message:{}", (Object)result.getMessage());
        throw new GoFastDfsException("request was aborted");
    }

    public <T> List<T> postToArr(String url, Object params, Class<T> clazz) {
        String res = this.getPostResult(url, params);
        GoFastDfsResult result = (GoFastDfsResult)JSON.parseObject((String)res, (TypeReference)new TypeReference<GoFastDfsResult<Object>>(){}, (Feature[])new Feature[0]);
        String status = result.getStatus();
        if ("ok".equals(status)) {
            return ObjectToBeanUtil.parseToList(result.getData(), clazz);
        }
        log.error("error result:{}", result.getData());
        log.error("error message:{}", (Object)result.getMessage());
        throw new GoFastDfsException("request was aborted");
    }

    private String getPostResult(String url, Object params) {
        JSONObject map = ObjectToBeanUtil.parse(params, JSONObject.class);
        String res = this.post(this.getBaseUrl() + url, (Map<String, Object>)map);
        if (!this.isJson(res).booleanValue()) {
            throw new GoFastDfsException(res);
        }
        return res;
    }

    public String post(String url, Map<String, Object> params) {
        String res = HttpUtil.post((String)url, params);
        if (!this.isJson(res).booleanValue()) {
            throw new GoFastDfsException(res);
        }
        return res;
    }

    public Boolean isJson(String s) {
        try {
            Object parse = JSON.parse((String)s);
            return Boolean.TRUE;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return Boolean.FALSE;
        }
    }

    public GoFastDfsUtil(GoFastDfsProperties properties) {
        this.properties = properties;
    }

    public GoFastDfsUtil() {
    }

    @FunctionalInterface
    public static interface ReloadAction {
        public void setConfig(GoFastDfsConfig var1);
    }
}

