/*
 * Decompiled with CFR 0.152.
 */
package cn.com.pism.mybatis.core;

import cn.com.pism.mybatis.core.method.MybatisMethod;
import com.baomidou.mybatisplus.core.injector.AbstractMethod;
import com.baomidou.mybatisplus.core.injector.DefaultSqlInjector;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.session.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class MybatisSqlInjector
extends DefaultSqlInjector
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(MybatisSqlInjector.class);
    private ApplicationContext applicationContext;

    public List<AbstractMethod> getMethodList(Configuration configuration, Class<?> mapperClass, TableInfo tableInfo) {
        List methodList = super.getMethodList(configuration, mapperClass, tableInfo);
        try {
            Map beans = this.applicationContext.getBeansOfType(MybatisMethod.class);
            if (!CollectionUtils.isEmpty((Map)beans)) {
                methodList.addAll(beans.values());
            }
        }
        catch (BeansException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return methodList;
    }

    public void setApplicationContext(@Nonnull ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

