/*
 * Decompiled with CFR 0.152.
 */
package cn.com.pism.mybatis.core.aspect;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public abstract class EntityFillAspect {
    private static final Logger log = LoggerFactory.getLogger(EntityFillAspect.class);

    @Pointcut(value="@annotation(cn.com.pism.mybatis.core.annotation.EntityFill)")
    public void pointcut() {
    }

    @Before(value="pointcut()")
    public void before(JoinPoint jp) {
        Object[] args = jp.getArgs();
        if (args != null) {
            for (Object arg : args) {
                this.parseObject(arg);
                log.trace("fill after:{}", arg);
            }
        }
    }

    private void parseObject(Object arg) {
        if (arg != null) {
            if (arg instanceof List) {
                ((List)arg).forEach(this::enhance);
            }
            this.enhance(arg);
        }
    }

    private void enhance(Object o) {
        if (o != null && !BeanUtils.isSimpleValueType(o.getClass())) {
            this.parseFields(o);
            if (this.needEnhance(o)) {
                this.doEnhance(o);
            }
        }
    }

    private void parseFields(Object o) {
        Field[] fields;
        for (Field field : fields = o.getClass().getDeclaredFields()) {
            try {
                int modifiers;
                if (field == null || BeanUtils.isSimpleProperty(field.getType()) || Modifier.isFinal(modifiers = field.getModifiers())) continue;
                Object result = field.get(o);
                this.parseObject(result);
            }
            catch (IllegalAccessException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected boolean needEnhance(Object o) {
        return true;
    }

    protected abstract void doEnhance(Object var1);
}

