/*
 * Decompiled with CFR 0.152.
 */
package cn.com.pism.mybatis.core.method;

import cn.com.pism.exception.PismException;
import com.baomidou.mybatisplus.core.injector.AbstractMethod;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import jakarta.annotation.Resource;
import java.io.IOException;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlSource;
import org.springframework.ui.freemarker.FreeMarkerTemplateUtils;

public abstract class MybatisMethod
extends AbstractMethod {
    private Class<?> mapperClass;
    private Class<?> modelClass;
    private TableInfo tableInfo;
    @Resource
    private Configuration freeMarkerConfiguration;

    protected MybatisMethod(String methodName) {
        super(methodName);
    }

    public MappedStatement injectMappedStatement(Class<?> mapperClass, Class<?> modelClass, TableInfo tableInfo) {
        String sql;
        this.modelClass = modelClass;
        this.mapperClass = mapperClass;
        this.tableInfo = tableInfo;
        try {
            Template template = this.freeMarkerConfiguration.getTemplate(this.methodName + ".ftlh");
            sql = tableInfo.getKeyProperty() != null && !tableInfo.getKeyProperty().isEmpty() ? "\u6682\u4e0d\u652f\u6301\u65e0\u4e3b\u952e\u5b9e\u4f53" : FreeMarkerTemplateUtils.processTemplateIntoString((Template)template, (Object)this.tableInfoPreProcess(tableInfo));
        }
        catch (TemplateException | IOException e) {
            throw new PismException(this.methodName + " sql\u6a21\u7248\u672a\u5b9a\u4e49");
        }
        SqlSource sqlSource = this.languageDriver.createSqlSource(this.configuration, String.format("<script>\n %s \n</script>", sql), modelClass);
        return this.addMappedStatement(sqlSource);
    }

    protected TableInfo tableInfoPreProcess(TableInfo tableInfo) {
        return tableInfo;
    }

    protected abstract MappedStatement addMappedStatement(SqlSource var1);

    public Class<?> getMapperClass() {
        return this.mapperClass;
    }

    public Class<?> getModelClass() {
        return this.modelClass;
    }

    public TableInfo getTableInfo() {
        return this.tableInfo;
    }

    public Configuration getFreeMarkerConfiguration() {
        return this.freeMarkerConfiguration;
    }
}

