/*
 * Decompiled with CFR 0.152.
 */
package cn.com.pism.pmrb.wechat.work.msg;

import cn.com.pism.pmrb.core.util.ImageUtil;
import cn.com.pism.pmrb.core.util.StringUtil;
import cn.com.pism.pmrb.wechat.work.msg.WechatWorkMsg;
import cn.com.pism.pmrb.wechat.work.msg.enums.WechatWorkMsgTypeEnum;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Image
extends WechatWorkMsg {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String IMAGE_MSG = "{\"base64\":\"%s\",\"md5\":\"%s\"}";
    private File file;
    private String base64;
    private String md5;

    public Image() {
        super(WechatWorkMsgTypeEnum.IMAGE);
    }

    public static Image instance() {
        return new Image();
    }

    public Image file(File file) {
        this.file = file;
        return this;
    }

    public Image base64(String base64) {
        this.base64 = base64;
        return this;
    }

    public Image md5(String md5) {
        this.md5 = md5;
        return this;
    }

    @Override
    public String getMsgContent() {
        if (StringUtil.isNotBlank((CharSequence)this.base64) && StringUtil.isNotBlank((CharSequence)this.md5)) {
            return String.format(IMAGE_MSG, this.base64, this.md5);
        }
        if (this.file != null) {
            return String.format(IMAGE_MSG, ImageUtil.base64((File)this.file), ImageUtil.md5((File)this.file));
        }
        return String.format(IMAGE_MSG, "", "");
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String getBase64() {
        return this.base64;
    }

    public void setBase64(String base64) {
        this.base64 = base64;
    }

    public String getMd5() {
        return this.md5;
    }

    public void setMd5(String md5) {
        this.md5 = md5;
    }
}

