/*
 * Decompiled with CFR 0.152.
 */
package cn.com.pism.pmrb.wechat.work.msg;

import cn.com.pism.pmrb.core.util.CollectionUtil;
import cn.com.pism.pmrb.wechat.work.msg.NewsArticle;
import cn.com.pism.pmrb.wechat.work.msg.WechatWorkMsg;
import cn.com.pism.pmrb.wechat.work.msg.enums.WechatWorkMsgTypeEnum;
import java.util.ArrayList;
import java.util.List;

public class News
extends WechatWorkMsg {
    private static final String NEWS_MSG = "{\"articles\":[%s]}";
    private static final String NEWS_MSG_ARTICLE = "{\"title\":\"%s\",\"description\":\"%s\",\"url\":\"%s\",\"picurl\":\"%s\"}";
    private List<NewsArticle> articles;

    public News() {
        super(WechatWorkMsgTypeEnum.NEWS);
    }

    public static News instance() {
        return new News();
    }

    public List<NewsArticle> getArticles() {
        return this.articles;
    }

    public void setArticles(List<NewsArticle> articles) {
        this.articles = articles;
    }

    public News addArticle(NewsArticle article) {
        if (CollectionUtil.isEmpty(this.articles)) {
            this.articles = new ArrayList<NewsArticle>();
        }
        this.articles.add(article);
        return this;
    }

    public News articles(List<NewsArticle> articles) {
        this.articles = articles;
        return this;
    }

    @Override
    public String getMsgContent() {
        if (CollectionUtil.isNotEmpty(this.articles)) {
            if (this.articles.size() > 8) {
                this.articles = this.articles.subList(0, 7);
            }
            ArrayList<String> articleList = new ArrayList<String>();
            for (NewsArticle article : this.articles) {
                articleList.add(String.format(NEWS_MSG_ARTICLE, article.getTitle(), article.getDescription(), article.getUrl(), article.getPicUrl()));
            }
            return String.format(NEWS_MSG, String.join((CharSequence)",", articleList));
        }
        return "";
    }
}

