/*
 * Decompiled with CFR 0.152.
 */
package cn.com.pism.pmrb.wechat.work.msg;

import cn.com.pism.pmrb.core.util.CollectionUtil;
import cn.com.pism.pmrb.wechat.work.msg.WechatWorkMsg;
import cn.com.pism.pmrb.wechat.work.msg.enums.WechatWorkMsgTypeEnum;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Text
extends WechatWorkMsg {
    private static final String TEXT_MSG = "{\"content\":\"%s\",\"mentioned_list\":[%s],\"mentioned_mobile_list\":[%s]}";
    private String content;
    private List<String> mentionedList;
    private List<String> mentionedMobileList;

    public Text() {
        super(WechatWorkMsgTypeEnum.TEXT);
    }

    public static Text instance() {
        return new Text();
    }

    public Text content(String content) {
        this.content = content;
        return this;
    }

    public Text mentionedList(List<String> mentionedList) {
        this.mentionedList = mentionedList;
        return this;
    }

    public Text mentionedList(String ... mentionedList) {
        this.mentionedList = new ArrayList<String>(Arrays.asList(mentionedList));
        return this;
    }

    public Text mentionedMobileList(List<String> mentionedMobileList) {
        this.mentionedMobileList = mentionedMobileList;
        return this;
    }

    public Text mentionedMobileList(String ... mentionedMobileList) {
        this.mentionedMobileList = new ArrayList<String>(Arrays.asList(mentionedMobileList));
        return this;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public List<String> getMentionedList() {
        return this.mentionedList;
    }

    public void setMentionedList(List<String> mentionedList) {
        this.mentionedList = mentionedList;
    }

    public List<String> getMentionedMobileList() {
        return this.mentionedMobileList;
    }

    public void setMentionedMobileList(List<String> mentionedMobileList) {
        this.mentionedMobileList = mentionedMobileList;
    }

    public Text atAll() {
        if (CollectionUtil.isNotEmpty(this.mentionedList)) {
            this.mentionedList.add("@all");
        } else if (CollectionUtil.isNotEmpty(this.mentionedMobileList)) {
            this.mentionedMobileList.add("@all");
        } else {
            this.mentionedList = new ArrayList<String>();
            this.mentionedList.add("@all");
        }
        return this;
    }

    @Override
    public String getMsgContent() {
        String mentionedListStr = "";
        String mentionedMobileListStr = "";
        if (CollectionUtil.isNotEmpty(this.mentionedList)) {
            mentionedListStr = String.join((CharSequence)"\",\"", this.mentionedList);
        }
        if (CollectionUtil.isNotEmpty(this.mentionedMobileList)) {
            mentionedMobileListStr = String.join((CharSequence)"\",\"", this.mentionedMobileList);
        }
        return String.format(TEXT_MSG, this.content, String.format("\"%s\"", mentionedListStr), String.format("\"%s\"", mentionedMobileListStr));
    }
}

