/*
 * Decompiled with CFR 0.152.
 */
package cn.com.pism.pmrb.wechat.work.msg.template.card;

import cn.com.pism.pmrb.core.model.JsonConcat;
import cn.com.pism.pmrb.core.util.EnhanceUtil;
import cn.com.pism.pmrb.core.util.StringUtil;
import cn.com.pism.pmrb.wechat.work.msg.enums.CardTypeEnum;
import cn.com.pism.pmrb.wechat.work.msg.enums.WechatWorkMsgTypeEnum;
import cn.com.pism.pmrb.wechat.work.msg.template.card.CardImage;
import cn.com.pism.pmrb.wechat.work.msg.template.card.ImageTextArea;
import cn.com.pism.pmrb.wechat.work.msg.template.card.TemplateCard;
import cn.com.pism.pmrb.wechat.work.msg.template.card.VerticalContent;
import java.util.List;
import java.util.stream.Collectors;

public class TemplateCardNewsNotice
extends TemplateCard<TemplateCardNewsNotice> {
    private static final String CARD_NEWS_NOTICE_MSG = "{%s, %s}";
    private CardImage cardImage;
    private ImageTextArea imageTextArea;
    private List<VerticalContent> verticalContentList;

    public TemplateCardNewsNotice() {
        super(WechatWorkMsgTypeEnum.TEMPLATE_CARD, CardTypeEnum.NEWS_NOTICE);
    }

    public static TemplateCardNewsNotice instance() {
        return new TemplateCardNewsNotice();
    }

    public TemplateCardNewsNotice cardImage(CardImage cardImage) {
        this.cardImage = cardImage;
        return this;
    }

    public TemplateCardNewsNotice imageTextArea(ImageTextArea imageTextArea) {
        this.imageTextArea = imageTextArea;
        return this;
    }

    public TemplateCardNewsNotice verticalContentList(List<VerticalContent> verticalContentList) {
        this.verticalContentList = verticalContentList;
        return this;
    }

    public CardImage getCardImage() {
        return this.cardImage;
    }

    public void setCardImage(CardImage cardImage) {
        this.cardImage = cardImage;
    }

    public ImageTextArea getImageTextArea() {
        return this.imageTextArea;
    }

    public void setImageTextArea(ImageTextArea imageTextArea) {
        this.imageTextArea = imageTextArea;
    }

    public List<VerticalContent> getVerticalContentList() {
        return this.verticalContentList;
    }

    public void setVerticalContentList(List<VerticalContent> verticalContentList) {
        this.verticalContentList = verticalContentList;
    }

    @Override
    public String getMsgContent() {
        String newsNotice = JsonConcat.instance().concat("\"card_image\":%s", EnhanceUtil.isNotNull((Object)this.cardImage, CardImage::toJson)).concat("\"image_text_area\":%s", EnhanceUtil.isNotNull((Object)this.imageTextArea, ImageTextArea::toJson)).concat("\"vertical_content_list\":[%s]", EnhanceUtil.isNotNull(this.verticalContentList, vcList -> vcList.stream().map(VerticalContent::toJson).collect(Collectors.joining(",")))).concat();
        if (StringUtil.isBlank((CharSequence)newsNotice)) {
            return String.format("{%s}", super.toJson());
        }
        return String.format(CARD_NEWS_NOTICE_MSG, super.toJson(), newsNotice);
    }

    @Override
    protected TemplateCardNewsNotice getInstance() {
        return this;
    }
}

