/*
 * Decompiled with CFR 0.152.
 */
package cn.com.pism.pmrb.wechat.work.msg;

import cn.com.pism.pmrb.core.util.StringUtil;
import cn.com.pism.pmrb.wechat.work.msg.WechatWorkMsg;
import cn.com.pism.pmrb.wechat.work.msg.enums.MarkdownTextColorEnum;
import cn.com.pism.pmrb.wechat.work.msg.enums.WechatWorkMsgTypeEnum;

public class Markdown
extends WechatWorkMsg {
    private static final String MARKDOWN_MSG = "{\"content\":\"%s\"}";
    private static final String HASH = "#";
    private static final String BOLD = "**%s**";
    private static final String LINK = "[%s](%s)";
    private static final String CODE = "`%s`";
    private static final String COLOR_TEXT = "<font color=%s>%s</font>";
    private static final String LINE_BREAK = "\n";
    private String content = "";

    public Markdown() {
        super(WechatWorkMsgTypeEnum.MARKDOWN);
    }

    public static Markdown instance() {
        return new Markdown();
    }

    public Markdown content(String content) {
        this.content = content;
        return this;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    @Override
    public String getMsgContent() {
        return String.format(MARKDOWN_MSG, StringUtil.cutUTF8StringByBytes((String)this.getContent(), (int)4096));
    }

    public Markdown addLine(String line) {
        this.content = this.content + LINE_BREAK + line;
        return this;
    }

    public Markdown append(String text) {
        this.content = this.content + text;
        return this;
    }

    public Markdown addTitle(String title) {
        return this.addTitle(title, 1);
    }

    public Markdown addTitle(String title, int level) {
        StringBuilder titleLevel = new StringBuilder();
        if (level > 6) {
            level = 6;
        }
        for (int i = 0; i < level; ++i) {
            titleLevel.append(HASH);
        }
        return this.addLine(titleLevel + " " + title);
    }

    public Markdown addBoldText(String text, boolean breakLine) {
        String boldText = String.format(BOLD, text);
        if (breakLine) {
            return this.addLine(boldText);
        }
        return this.append(boldText);
    }

    public Markdown addLink(String link, String linkName, boolean breakLine) {
        String linkText = String.format(LINK, linkName, link);
        if (breakLine) {
            return this.addLine(linkText);
        }
        return this.append(linkText);
    }

    public Markdown addCodeSnippet(String code) {
        return this.addLine(String.format(CODE, code));
    }

    public static String colorText(String text, MarkdownTextColorEnum color) {
        return String.format(COLOR_TEXT, color.getCode(), text);
    }

    public static String bold(String text) {
        return String.format(BOLD, text);
    }
}

