/*
 * Decompiled with CFR 0.152.
 */
package cn.com.pism.pmrb.core.function;

import cn.com.pism.pmrb.core.model.RobinConfig;
import cn.com.pism.pmrb.core.model.RobinMsg;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRobinClient<M, C extends RobinConfig> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private C config;

    protected abstract void doSend(RobinMsg<M> var1);

    public void send(M msg, Map<String, Object> params) {
        Long delay = ((RobinConfig)this.config).getDelay();
        if (delay != null) {
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException e) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
                Thread.currentThread().interrupt();
            }
        } else {
            this.doSend(new RobinMsg<M>(msg, params));
        }
    }

    public void send(M msg) {
        this.send(msg, null);
    }

    protected AbstractRobinClient(C config) {
        this.config = config;
    }

    public C getConfig() {
        return this.config;
    }

    public void setConfig(C config) {
        this.config = config;
    }
}

