package cn.com.rubintry.nbui.core.utils;

import android.app.Activity;
import android.content.res.Resources;
import android.view.WindowManager;

import androidx.annotation.NonNull;

public class BarUtils {

    public static int getStatusBarHeight(){
        Resources resources = Resources.getSystem();
        int resourceId = resources.getIdentifier("status_bar_height", "dimen", "android");
        return resources.getDimensionPixelSize(resourceId);
    }

    public static boolean isStatusBarVisible(@NonNull final Activity activity) {
        int flags = activity.getWindow().getAttributes().flags;
        return (flags & WindowManager.LayoutParams.FLAG_FULLSCREEN) == 0;
    }
}
