package cn.com.rubintry.nbui.drag;

import android.app.Activity;
import android.content.Context;
import android.view.MotionEvent;

import cn.com.rubintry.nbui.core.NBUI;
import cn.com.rubintry.nbui.core.config.NBFloatViewConfig;
import cn.com.rubintry.nbui.core.utils.BarUtils;

public class MoveHelper {

    public static boolean isEnableMove(Context context, MotionEvent event){
        NBFloatViewConfig config = NBUI.getInstance().config(NBFloatViewConfig.class);
        try {
            if(!config.isEnableTouchEdge()){
                return !(event.getX() - config.getWidth() / 2f < 0) && !(event.getY() - config.getHeight() / 2f < 0);
            }
            if(!config.isEnableTouchStatusBar()){
                //当你的页面使用沉浸式状态栏时才做以下处理（普通状态栏你view也碰不到它^_^）
                if(!BarUtils.isStatusBarVisible((Activity) context) && (event.getY() - config.getHeight() / 2f < BarUtils.getStatusBarHeight())){
                    return false;
                }
            }
        }catch (Exception e){
            return true;
        }
        return true;
    }
}
