package com.gitee.sunchenbin.mybatis.actable;

import com.gitee.sunchenbin.mybatis.actable.manager.handler.StartUpHandler;
import com.gitee.sunchenbin.mybatis.actable.manager.handler.StartUpHandlerImpl;
import org.apache.ibatis.annotations.Mapper;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.context.properties.ConfigurationPropertiesScan;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;

/**
 * 自动扫描actable下的内容 1. mapper 2. service
 *
 * @author wfu7326
 */
@ComponentScan("com.gitee.sunchenbin.mybatis.actable")
@ConfigurationPropertiesScan
@MapperScan(annotationClass = Mapper.class)
public class ActableAutoConfiguration {

	@Bean
	public StartUpHandler startUpHandler() {
		return new StartUpHandlerImpl();
	}

}
