/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.sunchenbin.mybatis.actable.utils;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.gitee.sunchenbin.mybatis.actable.annotation.ColumnComment;
import com.gitee.sunchenbin.mybatis.actable.annotation.ColumnType;
import com.gitee.sunchenbin.mybatis.actable.annotation.DefaultValue;
import com.gitee.sunchenbin.mybatis.actable.annotation.EnableTimeSuffix;
import com.gitee.sunchenbin.mybatis.actable.annotation.IgnoreTable;
import com.gitee.sunchenbin.mybatis.actable.annotation.IsAutoIncrement;
import com.gitee.sunchenbin.mybatis.actable.annotation.IsKey;
import com.gitee.sunchenbin.mybatis.actable.annotation.IsNativeDefValue;
import com.gitee.sunchenbin.mybatis.actable.annotation.IsNotNull;
import com.gitee.sunchenbin.mybatis.actable.annotation.Table;
import com.gitee.sunchenbin.mybatis.actable.annotation.TableCharset;
import com.gitee.sunchenbin.mybatis.actable.annotation.TableComment;
import com.gitee.sunchenbin.mybatis.actable.annotation.TableEngine;
import com.gitee.sunchenbin.mybatis.actable.annotation.impl.ColumnImpl;
import com.gitee.sunchenbin.mybatis.actable.command.JavaToMysqlType;
import com.gitee.sunchenbin.mybatis.actable.command.MySqlTypeAndLength;
import com.gitee.sunchenbin.mybatis.actable.constants.MySqlCharsetConstant;
import com.gitee.sunchenbin.mybatis.actable.constants.MySqlEngineConstant;
import com.gitee.sunchenbin.mybatis.actable.constants.MySqlTypeConstant;
import com.google.common.base.CaseFormat;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Id;
import org.apache.commons.lang.time.DateFormatUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.util.StringUtils;

public class ColumnUtils {
    public static final String DEFAULTVALUE = "DEFAULT";
    public static final String SQL_ESCAPE_CHARACTER = "`";

    public static String getTableName(Class<?> clasz) {
        Table tableName = clasz.getAnnotation(Table.class);
        javax.persistence.Table tableNameCommon = clasz.getAnnotation(javax.persistence.Table.class);
        TableName tableNamePlus = clasz.getAnnotation(TableName.class);
        EnableTimeSuffix enableTimeSuffix = clasz.getAnnotation(EnableTimeSuffix.class);
        if (!ColumnUtils.hasTableAnnotation(clasz)) {
            return null;
        }
        String finalTableName = "";
        if (tableName != null && !StringUtils.isEmpty((Object)tableName.name())) {
            finalTableName = tableName.name();
        }
        if (tableName != null && !StringUtils.isEmpty((Object)tableName.value())) {
            finalTableName = tableName.value();
        }
        if (tableNameCommon != null && !StringUtils.isEmpty((Object)tableNameCommon.name())) {
            finalTableName = tableNameCommon.name();
        }
        if (tableNamePlus != null && !StringUtils.isEmpty((Object)tableNamePlus.value())) {
            finalTableName = tableNamePlus.value();
        }
        if (StringUtils.isEmpty((Object)finalTableName)) {
            finalTableName = ColumnUtils.getBuildLowerName(clasz.getSimpleName());
        }
        if (null != enableTimeSuffix && enableTimeSuffix.value()) {
            finalTableName = ColumnUtils.appendTimeSuffix(finalTableName, enableTimeSuffix.pattern());
        }
        return finalTableName;
    }

    public static String getTableComment(Class<?> clasz) {
        Table table = clasz.getAnnotation(Table.class);
        TableComment tableComment = clasz.getAnnotation(TableComment.class);
        if (!ColumnUtils.hasTableAnnotation(clasz)) {
            return "";
        }
        if (table != null && !StringUtils.isEmpty((Object)table.comment())) {
            return table.comment();
        }
        if (tableComment != null && !StringUtils.isEmpty((Object)tableComment.value())) {
            return tableComment.value();
        }
        return "";
    }

    public static MySqlCharsetConstant getTableCharset(Class<?> clasz) {
        Table table = clasz.getAnnotation(Table.class);
        TableCharset charset = clasz.getAnnotation(TableCharset.class);
        if (!ColumnUtils.hasTableAnnotation(clasz)) {
            return null;
        }
        if (table != null && table.charset() != MySqlCharsetConstant.DEFAULT) {
            return table.charset();
        }
        if (charset != null && !StringUtils.isEmpty((Object)((Object)charset.value()))) {
            return charset.value();
        }
        return null;
    }

    public static MySqlEngineConstant getTableEngine(Class<?> clasz) {
        Table table = clasz.getAnnotation(Table.class);
        TableEngine engine = clasz.getAnnotation(TableEngine.class);
        if (!ColumnUtils.hasTableAnnotation(clasz)) {
            return null;
        }
        if (table != null && table.engine() != MySqlEngineConstant.DEFAULT) {
            return table.engine();
        }
        if (engine != null && !StringUtils.isEmpty((Object)((Object)engine.value()))) {
            return engine.value();
        }
        return null;
    }

    public static String getColumnName(Field field, Class<?> clasz) {
        com.gitee.sunchenbin.mybatis.actable.annotation.Column column = ColumnUtils.getColumn(field, clasz);
        Column columnCommon = field.getAnnotation(Column.class);
        TableField tableField = field.getAnnotation(TableField.class);
        TableId tableId = field.getAnnotation(TableId.class);
        if (!ColumnUtils.hasColumnAnnotation(field, clasz)) {
            return null;
        }
        if (column != null && !StringUtils.isEmpty((Object)column.name())) {
            return column.name().toLowerCase().replace(SQL_ESCAPE_CHARACTER, "");
        }
        if (column != null && !StringUtils.isEmpty((Object)column.value())) {
            return column.value().toLowerCase().replace(SQL_ESCAPE_CHARACTER, "");
        }
        if (columnCommon != null && !StringUtils.isEmpty((Object)columnCommon.name())) {
            return columnCommon.name().toLowerCase().replace(SQL_ESCAPE_CHARACTER, "");
        }
        if (tableField != null && !StringUtils.isEmpty((Object)tableField.value()) && tableField.exist()) {
            return tableField.value().toLowerCase().replace(SQL_ESCAPE_CHARACTER, "");
        }
        if (tableId != null && !StringUtils.isEmpty((Object)tableId.value())) {
            return tableId.value().replace(SQL_ESCAPE_CHARACTER, "");
        }
        return ColumnUtils.getBuildLowerName(field.getName()).replace(SQL_ESCAPE_CHARACTER, "");
    }

    private static String getBuildLowerName(String name) {
        return CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, name).toLowerCase();
    }

    public static boolean isKey(Field field, Class<?> clasz) {
        com.gitee.sunchenbin.mybatis.actable.annotation.Column column = ColumnUtils.getColumn(field, clasz);
        if (!ColumnUtils.hasColumnAnnotation(field, clasz)) {
            return false;
        }
        IsKey isKey = field.getAnnotation(IsKey.class);
        Id id = field.getAnnotation(Id.class);
        TableId tableId = field.getAnnotation(TableId.class);
        if (null != isKey) {
            return true;
        }
        if (column != null && column.isKey()) {
            return true;
        }
        if (null != id) {
            return true;
        }
        return null != tableId;
    }

    public static boolean isAutoIncrement(Field field, Class<?> clasz) {
        com.gitee.sunchenbin.mybatis.actable.annotation.Column column = ColumnUtils.getColumn(field, clasz);
        if (!ColumnUtils.hasColumnAnnotation(field, clasz)) {
            return false;
        }
        IsAutoIncrement isAutoIncrement = field.getAnnotation(IsAutoIncrement.class);
        if (null != isAutoIncrement) {
            return true;
        }
        return column != null && column.isAutoIncrement();
    }

    public static Boolean isNull(Field field, Class<?> clasz) {
        com.gitee.sunchenbin.mybatis.actable.annotation.Column column = ColumnUtils.getColumn(field, clasz);
        Column columnCommon = field.getAnnotation(Column.class);
        if (!ColumnUtils.hasColumnAnnotation(field, clasz)) {
            return true;
        }
        boolean iskey = ColumnUtils.isKey(field, clasz);
        if (iskey) {
            return false;
        }
        IsNotNull isNotNull = field.getAnnotation(IsNotNull.class);
        if (null != isNotNull) {
            return false;
        }
        if (column != null) {
            return column.isNull();
        }
        if (columnCommon != null) {
            return columnCommon.nullable();
        }
        return true;
    }

    public static String getComment(Field field, Class<?> clasz) {
        com.gitee.sunchenbin.mybatis.actable.annotation.Column column = ColumnUtils.getColumn(field, clasz);
        ColumnComment comment = field.getAnnotation(ColumnComment.class);
        if (!ColumnUtils.hasColumnAnnotation(field, clasz)) {
            return null;
        }
        if (column != null && !StringUtils.isEmpty((Object)column.comment())) {
            return column.comment();
        }
        if (comment != null && !StringUtils.isEmpty((Object)comment.value())) {
            return comment.value();
        }
        return "";
    }

    public static String getDefaultValue(Field field, Class<?> clasz) {
        com.gitee.sunchenbin.mybatis.actable.annotation.Column column = ColumnUtils.getColumn(field, clasz);
        DefaultValue defaultValue = field.getAnnotation(DefaultValue.class);
        if (!ColumnUtils.hasColumnAnnotation(field, clasz)) {
            return null;
        }
        if (column != null && !DEFAULTVALUE.equals(column.defaultValue())) {
            return column.defaultValue();
        }
        if (defaultValue != null) {
            return defaultValue.value();
        }
        return null;
    }

    public static boolean getDefaultValueNative(Field field, Class<?> clasz) {
        IsNativeDefValue isNativeDefValue = field.getAnnotation(IsNativeDefValue.class);
        if (isNativeDefValue != null) {
            return isNativeDefValue.value();
        }
        return !field.getGenericType().toString().equals("class java.lang.String") && !field.getGenericType().toString().equals("char") && !field.getGenericType().toString().equals("class java.lang.Boolean") && !field.getGenericType().toString().equals("boolean");
    }

    public static MySqlTypeAndLength getMySqlTypeAndLength(Field field, Class<?> clasz) {
        com.gitee.sunchenbin.mybatis.actable.annotation.Column column = ColumnUtils.getColumn(field, clasz);
        Column columnCommon = field.getAnnotation(Column.class);
        ColumnType type = field.getAnnotation(ColumnType.class);
        if (!ColumnUtils.hasColumnAnnotation(field, clasz)) {
            throw new RuntimeException("\u5b57\u6bb5\u540d\uff1a" + field.getName() + "\u6ca1\u6709\u5b57\u6bb5\u6807\u8bc6\u7684\u6ce8\u89e3\uff0c\u5f02\u5e38\u629b\u51fa\uff01");
        }
        if (column != null && column.type() != MySqlTypeConstant.DEFAULT) {
            return ColumnUtils.buildMySqlTypeAndLength(field, column.type().toString().toLowerCase(), column.length(), column.decimalLength());
        }
        if (type != null && type.value() != null && type.value() != MySqlTypeConstant.DEFAULT) {
            return ColumnUtils.buildMySqlTypeAndLength(field, type.value().toString().toLowerCase(), type.length(), type.decimalLength());
        }
        if (type != null && columnCommon != null && type.value() != null && type.value() != MySqlTypeConstant.DEFAULT) {
            return ColumnUtils.buildMySqlTypeAndLength(field, type.value().toString().toLowerCase(), columnCommon.length(), columnCommon.scale());
        }
        MySqlTypeConstant mysqlType = JavaToMysqlType.javaToMysqlTypeMap.get(field.getGenericType().toString());
        if (mysqlType == null) {
            throw new RuntimeException("\u5b57\u6bb5\u540d\uff1a" + field.getName() + "\u4e0d\u652f\u6301" + field.getGenericType().toString() + "\u7c7b\u578b\u8f6c\u6362\u5230mysql\u7c7b\u578b\uff0c\u4ec5\u652f\u6301JavaToMysqlType\u7c7b\u4e2d\u7684\u7c7b\u578b\u9ed8\u8ba4\u8f6c\u6362\uff0c\u5f02\u5e38\u629b\u51fa\uff01");
        }
        String sqlType = mysqlType.toString().toLowerCase();
        if (column != null) {
            return ColumnUtils.buildMySqlTypeAndLength(field, sqlType, column.length(), column.decimalLength());
        }
        if (type != null) {
            return ColumnUtils.buildMySqlTypeAndLength(field, sqlType, type.length(), type.decimalLength());
        }
        if (columnCommon != null) {
            return ColumnUtils.buildMySqlTypeAndLength(field, sqlType, columnCommon.length(), columnCommon.scale());
        }
        return ColumnUtils.buildMySqlTypeAndLength(field, sqlType, 255, 0);
    }

    private static MySqlTypeAndLength buildMySqlTypeAndLength(Field field, String type, int length, int decimalLength) {
        MySqlTypeAndLength mySqlTypeAndLength = MySqlTypeConstant.mySqlTypeAndLengthMap.get(type);
        if (mySqlTypeAndLength == null) {
            throw new RuntimeException("\u5b57\u6bb5\u540d\uff1a" + field.getName() + "\u4f7f\u7528\u7684" + type + "\u7c7b\u578b\uff0c\u6ca1\u6709\u914d\u7f6e\u5bf9\u5e94\u7684MySqlTypeConstant\uff0c\u53ea\u652f\u6301\u521b\u5efaMySqlTypeConstant\u4e2d\u7c7b\u578b\u7684\u5b57\u6bb5\uff0c\u5f02\u5e38\u629b\u51fa\uff01");
        }
        MySqlTypeAndLength targetMySqlTypeAndLength = new MySqlTypeAndLength();
        BeanUtils.copyProperties((Object)mySqlTypeAndLength, (Object)targetMySqlTypeAndLength);
        if (length != 255) {
            targetMySqlTypeAndLength.setLength(length);
        }
        if (decimalLength != 0) {
            targetMySqlTypeAndLength.setDecimalLength(decimalLength);
        }
        return targetMySqlTypeAndLength;
    }

    public static boolean hasTableAnnotation(Class<?> clasz) {
        Table tableName = clasz.getAnnotation(Table.class);
        javax.persistence.Table tableNameCommon = clasz.getAnnotation(javax.persistence.Table.class);
        TableName tableNamePlus = clasz.getAnnotation(TableName.class);
        return tableName != null || tableNameCommon != null || tableNamePlus != null;
    }

    public static boolean hasIgnoreTableAnnotation(Class<?> clasz) {
        IgnoreTable ignoreTable = clasz.getAnnotation(IgnoreTable.class);
        return ignoreTable != null;
    }

    public static boolean hasColumnAnnotation(Field field, Class<?> clasz) {
        boolean isSimple = ColumnUtils.isSimple(clasz);
        String[] excludeFields = ColumnUtils.excludeFields(clasz);
        if (Arrays.asList(excludeFields).contains(field.getName())) {
            return false;
        }
        com.gitee.sunchenbin.mybatis.actable.annotation.Column column = field.getAnnotation(com.gitee.sunchenbin.mybatis.actable.annotation.Column.class);
        Column columnCommon = field.getAnnotation(Column.class);
        TableField tableField = field.getAnnotation(TableField.class);
        IsKey isKey = field.getAnnotation(IsKey.class);
        Id id = field.getAnnotation(Id.class);
        TableId tableId = field.getAnnotation(TableId.class);
        if (!(column != null || columnCommon != null || tableField != null && tableField.exist() || isKey != null || id != null || tableId != null)) {
            return isSimple;
        }
        return true;
    }

    private static com.gitee.sunchenbin.mybatis.actable.annotation.Column getColumn(Field field, Class<?> clasz) {
        String[] excludeFields = ColumnUtils.excludeFields(clasz);
        if (Arrays.asList(excludeFields).contains(field.getName())) {
            return null;
        }
        com.gitee.sunchenbin.mybatis.actable.annotation.Column column = field.getAnnotation(com.gitee.sunchenbin.mybatis.actable.annotation.Column.class);
        if (column != null) {
            return column;
        }
        boolean isSimple = ColumnUtils.isSimple(clasz);
        if (isSimple) {
            return new ColumnImpl();
        }
        return null;
    }

    private static String[] excludeFields(Class<?> clasz) {
        String[] excludeFields = new String[]{};
        Table tableName = clasz.getAnnotation(Table.class);
        if (tableName != null) {
            excludeFields = tableName.excludeFields();
        }
        return excludeFields;
    }

    private static boolean isSimple(Class<?> clasz) {
        boolean isSimple = false;
        Table tableName = clasz.getAnnotation(Table.class);
        if (tableName != null) {
            isSimple = tableName.isSimple();
        }
        return isSimple;
    }

    public static String appendTimeSuffix(String tableName, String pattern) {
        String suffix = "";
        try {
            suffix = DateFormatUtils.format((Date)new Date(), (String)pattern);
        }
        catch (Exception e) {
            throw new RuntimeException("\u65e0\u6cd5\u8f6c\u6362\u65f6\u95f4\u683c\u5f0f" + pattern);
        }
        return tableName + "_" + suffix;
    }
}

