/*
 * Decompiled with CFR 0.152.
 */
package com.pig4cloud.pigx.common.core.exception;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.pig4cloud.pigx.common.core.exception.CheckedException;
import com.pig4cloud.pigx.common.core.exception.ValidateCodeException;
import com.pig4cloud.pigx.common.core.util.R;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.validation.BindException;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestController
@RestControllerAdvice
public class GlobalBizExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalBizExceptionHandler.class);
    private final ObjectMapper objectMapper = new ObjectMapper();

    @ExceptionHandler(value={Exception.class, CheckedException.class, ValidateCodeException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public R handleGlobalException(Exception e) {
        log.error("\u5168\u5c40\u5f02\u5e38\u4fe1\u606f ex={}", (Object)e.getMessage(), (Object)e);
        return R.failed(e.getLocalizedMessage());
    }

    @ExceptionHandler(value={BindException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public R handleBodyValidException(BindException exception) {
        List fieldErrors = exception.getBindingResult().getFieldErrors();
        return R.failed(String.format("%s %s", ((FieldError)fieldErrors.get(0)).getField(), ((FieldError)fieldErrors.get(0)).getDefaultMessage()));
    }

    @DeleteMapping(value={"/error"})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public R noHandlerFoundException() {
        return R.failed(HttpStatus.NOT_FOUND.getReasonPhrase());
    }
}

