/*
 * Decompiled with CFR 0.152.
 */
package com.pig4cloud.pigx.common.core.sensitive;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.pig4cloud.pigx.common.core.sensitive.Sensitive;
import com.pig4cloud.pigx.common.core.sensitive.SensitiveTypeEnum;
import com.pig4cloud.pigx.common.core.util.DesensitizedUtils;
import java.io.IOException;
import java.util.Objects;

public class SensitiveSerialize
extends JsonSerializer<String>
implements ContextualSerializer {
    private SensitiveTypeEnum type;
    private Integer prefixNoMaskLen;
    private Integer suffixNoMaskLen;
    private String maskStr;

    public void serialize(String origin, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        switch (this.type) {
            case CHINESE_NAME: {
                jsonGenerator.writeString(DesensitizedUtils.chineseName(origin));
                break;
            }
            case ID_CARD: {
                jsonGenerator.writeString(DesensitizedUtils.idCardNum(origin));
                break;
            }
            case FIXED_PHONE: {
                jsonGenerator.writeString(DesensitizedUtils.fixedPhone(origin));
                break;
            }
            case MOBILE_PHONE: {
                jsonGenerator.writeString(DesensitizedUtils.mobilePhone(origin));
                break;
            }
            case ADDRESS: {
                jsonGenerator.writeString(DesensitizedUtils.address(origin));
                break;
            }
            case EMAIL: {
                jsonGenerator.writeString(DesensitizedUtils.email(origin));
                break;
            }
            case BANK_CARD: {
                jsonGenerator.writeString(DesensitizedUtils.bankCard(origin));
                break;
            }
            case PASSWORD: {
                jsonGenerator.writeString(DesensitizedUtils.password(origin));
                break;
            }
            case KEY: {
                jsonGenerator.writeString(DesensitizedUtils.key(origin));
                break;
            }
            case CUSTOMER: {
                jsonGenerator.writeString(DesensitizedUtils.desValue(origin, this.prefixNoMaskLen, this.suffixNoMaskLen, this.maskStr));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknow sensitive type enum " + (Object)((Object)this.type));
            }
        }
    }

    public JsonSerializer<?> createContextual(SerializerProvider serializerProvider, BeanProperty beanProperty) throws JsonMappingException {
        if (beanProperty != null) {
            if (Objects.equals(beanProperty.getType().getRawClass(), String.class)) {
                Sensitive sensitive = (Sensitive)beanProperty.getAnnotation(Sensitive.class);
                if (sensitive == null) {
                    sensitive = (Sensitive)beanProperty.getContextAnnotation(Sensitive.class);
                }
                if (sensitive != null) {
                    return new SensitiveSerialize(sensitive.type(), sensitive.prefixNoMaskLen(), sensitive.suffixNoMaskLen(), sensitive.maskStr());
                }
            }
            return serializerProvider.findValueSerializer(beanProperty.getType(), beanProperty);
        }
        return serializerProvider.findNullValueSerializer(null);
    }

    public SensitiveSerialize() {
    }

    public SensitiveSerialize(SensitiveTypeEnum type, Integer prefixNoMaskLen, Integer suffixNoMaskLen, String maskStr) {
        this.type = type;
        this.prefixNoMaskLen = prefixNoMaskLen;
        this.suffixNoMaskLen = suffixNoMaskLen;
        this.maskStr = maskStr;
    }
}

