/*
 * Decompiled with CFR 0.152.
 */
package com.pig4cloud.pigx.common.core.util;

import cn.hutool.core.util.StrUtil;

public class DesensitizedUtils {
    public static String desValue(String origin, int prefixNoMaskLen, int suffixNoMaskLen, String maskStr) {
        if (origin == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int n = origin.length();
        for (int i = 0; i < n; ++i) {
            if (i < prefixNoMaskLen) {
                sb.append(origin.charAt(i));
                continue;
            }
            if (i > n - suffixNoMaskLen - 1) {
                sb.append(origin.charAt(i));
                continue;
            }
            sb.append(maskStr);
        }
        return sb.toString();
    }

    public static String chineseName(String fullName) {
        if (fullName == null) {
            return null;
        }
        return DesensitizedUtils.desValue(fullName, 0, 1, "*");
    }

    public static String idCardNum(String id) {
        return DesensitizedUtils.desValue(id, 6, 4, "*");
    }

    public static String fixedPhone(String num) {
        return DesensitizedUtils.desValue(num, 0, 4, "*");
    }

    public static String mobilePhone(String num) {
        return DesensitizedUtils.desValue(num, 3, 4, "*");
    }

    public static String address(String address) {
        return DesensitizedUtils.desValue(address, 6, 0, "*");
    }

    public static String email(String email) {
        if (email == null) {
            return null;
        }
        int index = StrUtil.indexOf((CharSequence)email, (char)'@');
        if (index <= 1) {
            return email;
        }
        String preEmail = DesensitizedUtils.desValue(email.substring(0, index), 1, 0, "*");
        return preEmail + email.substring(index);
    }

    public static String bankCard(String cardNum) {
        return DesensitizedUtils.desValue(cardNum, 6, 4, "*");
    }

    public static String password(String password) {
        if (password == null) {
            return null;
        }
        return "******";
    }

    public static String key(String key) {
        if (key == null) {
            return null;
        }
        int viewLength = 6;
        StringBuilder tmpKey = new StringBuilder(DesensitizedUtils.desValue(key, 0, 3, "*"));
        if (tmpKey.length() > viewLength) {
            return tmpKey.substring(tmpKey.length() - viewLength);
        }
        if (tmpKey.length() < viewLength) {
            int buffLength = viewLength - tmpKey.length();
            for (int i = 0; i < buffLength; ++i) {
                tmpKey.insert(0, "*");
            }
            return tmpKey.toString();
        }
        return tmpKey.toString();
    }
}

