/*
 * Decompiled with CFR 0.152.
 */
package com.pig4cloud.pigx.common.core.util;

import com.pig4cloud.pigx.common.core.constant.CommonConstants;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;

@Schema(description="\u54cd\u5e94\u4fe1\u606f\u4e3b\u4f53")
public class R<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Schema(description="\u8fd4\u56de\u6807\u8bb0\uff1a\u6210\u529f\u6807\u8bb0=0\uff0c\u5931\u8d25\u6807\u8bb0=1")
    private int code;
    @Schema(description="\u8fd4\u56de\u4fe1\u606f")
    private String msg;
    @Schema(description="\u6570\u636e")
    private T data;

    public static <T> R<T> ok() {
        return R.restResult(null, CommonConstants.SUCCESS, null);
    }

    public static <T> R<T> ok(T data) {
        return R.restResult(data, CommonConstants.SUCCESS, null);
    }

    public static <T> R<T> ok(T data, String msg) {
        return R.restResult(data, CommonConstants.SUCCESS, msg);
    }

    public static <T> R<T> failed() {
        return R.restResult(null, CommonConstants.FAIL, null);
    }

    public static <T> R<T> failed(String msg) {
        return R.restResult(null, CommonConstants.FAIL, msg);
    }

    public static <T> R<T> failed(T data) {
        return R.restResult(data, CommonConstants.FAIL, null);
    }

    public static <T> R<T> failed(T data, String msg) {
        return R.restResult(data, CommonConstants.FAIL, msg);
    }

    static <T> R<T> restResult(T data, int code, String msg) {
        R<T> apiResult = new R<T>();
        apiResult.setCode(code);
        apiResult.setData(data);
        apiResult.setMsg(msg);
        return apiResult;
    }

    public static <T> RBuilder<T> builder() {
        return new RBuilder();
    }

    public String toString() {
        return "R(code=" + this.getCode() + ", msg=" + this.getMsg() + ", data=" + this.getData() + ")";
    }

    public R() {
    }

    public R(int code, String msg, T data) {
        this.code = code;
        this.msg = msg;
        this.data = data;
    }

    public int getCode() {
        return this.code;
    }

    public R<T> setCode(int code) {
        this.code = code;
        return this;
    }

    public String getMsg() {
        return this.msg;
    }

    public R<T> setMsg(String msg) {
        this.msg = msg;
        return this;
    }

    public T getData() {
        return this.data;
    }

    public R<T> setData(T data) {
        this.data = data;
        return this;
    }

    public static class RBuilder<T> {
        private int code;
        private String msg;
        private T data;

        RBuilder() {
        }

        public RBuilder<T> code(int code) {
            this.code = code;
            return this;
        }

        public RBuilder<T> msg(String msg) {
            this.msg = msg;
            return this;
        }

        public RBuilder<T> data(T data) {
            this.data = data;
            return this;
        }

        public R<T> build() {
            return new R<T>(this.code, this.msg, this.data);
        }

        public String toString() {
            return "R.RBuilder(code=" + this.code + ", msg=" + this.msg + ", data=" + this.data + ")";
        }
    }
}

