/*
 * Decompiled with CFR 0.152.
 */
package com.pig4cloud.pigx.common.core.util;

import cn.hutool.core.util.ObjectUtil;
import com.pig4cloud.pigx.common.core.constant.CommonConstants;
import com.pig4cloud.pigx.common.core.util.R;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public class RetOps<T> {
    public static final Predicate<R<?>> CODE_SUCCESS = r -> CommonConstants.SUCCESS.intValue() == r.getCode();
    public static final Predicate<R<?>> HAS_DATA = r -> ObjectUtil.isNotEmpty(r.getData());
    public static final Predicate<R<?>> HAS_ELEMENT = r -> ObjectUtil.isNotEmpty(r.getData());
    public static final Predicate<R<?>> DATA_AVAILABLE = CODE_SUCCESS.and(HAS_DATA);
    private final R<T> original;

    RetOps(R<T> original) {
        this.original = original;
    }

    public static <T> RetOps<T> of(R<T> original) {
        return new RetOps<T>(Objects.requireNonNull(original));
    }

    public R<T> peek() {
        return this.original;
    }

    public int getCode() {
        return this.original.getCode();
    }

    public Optional<T> getData() {
        return Optional.ofNullable(this.original.getData());
    }

    public Optional<T> getDataIf(Predicate<? super R<?>> predicate) {
        return predicate.test(this.original) ? this.getData() : Optional.empty();
    }

    public Optional<String> getMsg() {
        return Optional.ofNullable(this.original.getMsg());
    }

    public boolean codeEquals(int value) {
        return this.original.getCode() == value;
    }

    public boolean codeNotEquals(int value) {
        return !this.codeEquals(value);
    }

    public boolean isSuccess() {
        return this.codeEquals(CommonConstants.SUCCESS);
    }

    public boolean notSuccess() {
        return !this.isSuccess();
    }

    public <Ex extends Exception> RetOps<T> assertCode(int expect, Function<? super R<T>, ? extends Ex> func) throws Ex {
        if (this.codeNotEquals(expect)) {
            throw (Exception)func.apply(this.original);
        }
        return this;
    }

    public <Ex extends Exception> RetOps<T> assertSuccess(Function<? super R<T>, ? extends Ex> func) throws Ex {
        return this.assertCode(CommonConstants.SUCCESS, func);
    }

    public <Ex extends Exception> RetOps<T> assertDataNotNull(Function<? super R<T>, ? extends Ex> func) throws Ex {
        if (Objects.isNull(this.original.getData())) {
            throw (Exception)func.apply(this.original);
        }
        return this;
    }

    public <Ex extends Exception> RetOps<T> assertDataNotEmpty(Function<? super R<T>, ? extends Ex> func) throws Ex {
        if (ObjectUtil.isEmpty(this.original.getData())) {
            throw (Exception)func.apply(this.original);
        }
        return this;
    }

    public <U> RetOps<U> map(Function<? super T, ? extends U> mapper) {
        R<U> result = R.restResult(mapper.apply(this.original.getData()), this.original.getCode(), this.original.getMsg());
        return RetOps.of(result);
    }

    public <U> RetOps<U> mapIf(Predicate<? super R<T>> predicate, Function<? super T, ? extends U> mapper) {
        R<U> result = R.restResult(mapper.apply(this.original.getData()), this.original.getCode(), this.original.getMsg());
        return RetOps.of(result);
    }

    public void useData(Consumer<? super T> consumer) {
        consumer.accept(this.original.getData());
    }

    public void useDataOnCode(Consumer<? super T> consumer, int ... codes) {
        this.useDataIf(o -> Arrays.stream(codes).filter(c -> this.original.getCode() == c).findFirst().isPresent(), consumer);
    }

    public void useDataIfSuccess(Consumer<? super T> consumer) {
        this.useDataIf(CODE_SUCCESS, consumer);
    }

    public void useDataIf(Predicate<? super R<T>> predicate, Consumer<? super T> consumer) {
        if (predicate.test(this.original)) {
            consumer.accept(this.original.getData());
        }
    }
}

