package com.pig4cloud.pigx.common.data.entity;

import com.baomidou.mybatisplus.annotation.*;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fhs.core.trans.vo.TransPojo;
import com.gitee.sunchenbin.mybatis.actable.annotation.Column;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.time.LocalDateTime;

/**
 * @author wfu7326
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class BaseEntity<T extends BaseEntity<?>> extends Model<T> implements TransPojo {

	@TableId(type = IdType.ASSIGN_ID)
	@Column(comment = "主键id")
	@Schema(description = "主键id")
	private Long id;

	/**
	 * 创建人
	 */
	@TableField(fill = FieldFill.INSERT)
	@Schema(description = "创建人")
	@Column(comment = "创建人")
	private String createBy;

	@TableField(fill = FieldFill.INSERT)
	@Schema(description = "创建人名称")
	@Column(comment = "创建人名称")
	private String createByName;

	/**
	 * 修改人
	 */
	@TableField(fill = FieldFill.UPDATE)
	@Schema(description = "修改人")
	@Column(comment = "修改人")
	private String updateBy;

	@TableField(fill = FieldFill.UPDATE)
	@Schema(description = "修改人名称")
	@Column(comment = "修改人名称")
	private String updateByName;

	/**
	 * 创建时间
	 */
	@Schema(description = "创建时间")
	@TableField(fill = FieldFill.INSERT)
	@Column(comment = "创建时间")
	private LocalDateTime createTime;

	/**
	 * 修改时间
	 */
	@Schema(description = "修改时间")
	@TableField(fill = FieldFill.UPDATE)
	@Column(comment = "修改时间")
	private LocalDateTime updateTime;

	/**
	 * 是否删除 1：已删除 0：正常
	 */
	@TableLogic
	@Schema(description = "删除标记,1:已删除,0:正常")
	@TableField(fill = FieldFill.INSERT)
	@Column(comment = "删除标记,1:已删除,0:正常", defaultValue = "0")
	private String delFlag;

	/**
	 * 租户ID
	 */
	@Schema(description = "租户ID", hidden = true)
	@Column(comment = "租户ID")
	private Long tenantId;

	public Boolean isExists() {
		return false;
	}

}
