package com.pig4cloud.pigx.common.data.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.lang.tree.Tree;
import cn.hutool.core.lang.tree.TreeNode;
import cn.hutool.core.lang.tree.TreeUtil;
import com.gitee.sunchenbin.mybatis.actable.annotation.Column;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Data
public class BaseTreeEntity<T extends BaseTreeEntity<?>> extends BaseEntity<T> {

	public static Long ROOT_ID = 0L;

	/**
	 * 父级部门id
	 */
	@Schema(description = "父级id")
	@Column(comment = "父级id")
	private Long parentId;

	public static <T extends BaseTreeEntity<?>> List<Tree<Long>> toTree(List<T> list, Long rootId) {

		List<TreeNode<Long>> collect = list.stream().map(item -> {
			TreeNode<Long> treeNode = new TreeNode();
			treeNode.setId(item.getId());
			treeNode.setParentId(item.getParentId());

			Map<String, Object> extra = new HashMap<>();

			BeanUtil.copyProperties(item, extra);
			treeNode.setExtra(extra);
			return treeNode;
		}).collect(Collectors.toList());

		return TreeUtil.build(collect, rootId);
	}

}
