package com.pig4cloud.pigx.common.data.feign.res;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

@Data
public class RoleRes {

	@TableId(value = "role_id", type = IdType.ASSIGN_ID)
	@Schema(description = "角色编号")
	private Long roleId;

	@NotBlank(message = "角色名称不能为空")
	@Schema(description = "角色名称")
	private String roleName;

	@NotBlank(message = "角色标识不能为空")
	@Schema(description = "角色标识")
	private String roleCode;

	@Schema(description = "角色描述")
	private String roleDesc;

	@NotNull(message = "数据权限类型不能为空")
	@Schema(description = "数据权限类型")
	private Integer dsType;

	/**
	 * 角色所属应用
	 */
	@Schema(description = "所属应用")
	private String application;

	/**
	 * 数据权限作用范围
	 */
	@Schema(description = "数据权限作用范围")
	private String dsScope;

}
