package com.pig4cloud.pigx.common.data.handler;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import lombok.SneakyThrows;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.MappedJdbcTypes;
import org.apache.ibatis.type.MappedTypes;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

/**
 * Mybatis json格式,符串互转
 * <p>
 * MappedJdbcTypes 数据库中的数据类型 MappedTypes java中的的数据类型
 *
 * @author aeizzz
 * @date 2021/1/26
 */
@MappedTypes(value = { JSONObject.class })
@MappedJdbcTypes(value = JdbcType.VARCHAR)
public class JsonTypeHandler extends BaseTypeHandler<JSONObject> {

	@Override
	public void setNonNullParameter(PreparedStatement preparedStatement, int i, JSONObject jsonObject,
			JdbcType jdbcType) throws SQLException {
		preparedStatement.setString(i, jsonObject.toString());
	}

	@Override
	public JSONObject getNullableResult(ResultSet resultSet, String columnName) throws SQLException {
		String reString = resultSet.getString(columnName);
		return JSONUtil.parseObj(reString);
	}

	@Override
	public JSONObject getNullableResult(ResultSet resultSet, int columnIndex) throws SQLException {
		String reString = resultSet.getString(columnIndex);
		return JSONUtil.parseObj(reString);
	}

	@Override
	public JSONObject getNullableResult(CallableStatement callableStatement, int columnIndex) throws SQLException {
		String reString = callableStatement.getString(columnIndex);
		return JSONUtil.parseObj(reString);
	}

}
