package com.pig4cloud.pigx.common.email.core;

import org.springframework.web.multipart.MultipartFile;

import javax.mail.MessagingException;
import java.io.File;

public interface EmailTemplate {

	/**
	 * 普通邮件
	 * @param toEmail
	 * @return
	 */
	Boolean commonEmail(ToEmail toEmail);

	/**
	 * html邮件
	 */
	Boolean htmlEmail(ToEmail toEmail) throws MessagingException;

	/**
	 * 含有文件的邮件
	 */
	Boolean staticEmail(ToEmail toEmail, File file, String resId);

	/**
	 * 带附件的邮件
	 * @param toEmail
	 * @param file
	 * @return
	 */
	Boolean enclosureEmail(ToEmail toEmail, File file);

}
