/*
 * Decompiled with CFR 0.152.
 */
package com.pig4cloud.pigx.common.email;

import com.pig4cloud.pigx.common.email.core.EmailTemplate;
import com.pig4cloud.pigx.common.email.core.ToEmail;
import java.io.File;
import java.util.Arrays;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;

public class DefaultEmailTemplate
implements EmailTemplate {
    private static final Logger log = LoggerFactory.getLogger(DefaultEmailTemplate.class);
    private final JavaMailSender mailSender;
    @Value(value="${spring.mail.username}")
    private String from;

    @Override
    public Boolean commonEmail(ToEmail toEmail) {
        SimpleMailMessage message = new SimpleMailMessage();
        message.setFrom(this.from);
        message.setTo(toEmail.getTos());
        message.setSubject(toEmail.getSubject());
        message.setText(toEmail.getContent());
        this.mailSender.send(message);
        log.info("\u90ae\u4ef6\u53d1\u9001\u6210\u529f -\u300b {}", Arrays.asList(toEmail.getTos()));
        return Boolean.TRUE;
    }

    @Override
    public Boolean htmlEmail(ToEmail toEmail) throws MessagingException {
        MimeMessage message = this.mailSender.createMimeMessage();
        MimeMessageHelper minehelper = new MimeMessageHelper(message, true);
        minehelper.setFrom(this.from);
        minehelper.setTo(toEmail.getTos());
        minehelper.setSubject(toEmail.getSubject());
        minehelper.setText(toEmail.getContent(), true);
        this.mailSender.send(message);
        log.info("\u90ae\u4ef6\u53d1\u9001\u6210\u529f -\u300b {}", Arrays.asList(toEmail.getTos()));
        return Boolean.TRUE;
    }

    @Override
    public Boolean staticEmail(ToEmail toEmail, File file, String resId) {
        MimeMessage message = this.mailSender.createMimeMessage();
        MimeMessageHelper helper = new MimeMessageHelper(message, true);
        helper.setFrom(this.from);
        helper.setTo(toEmail.getTos());
        helper.setSubject(toEmail.getSubject());
        String content = "<html><body><img width='250px' src='cid:" + resId + "'>" + toEmail.getContent() + "</body></html>";
        helper.setText(content, true);
        FileSystemResource res = new FileSystemResource(file);
        helper.addInline(resId, (Resource)res);
        this.mailSender.send(message);
        log.info("\u90ae\u4ef6\u53d1\u9001\u6210\u529f -\u300b {}", Arrays.asList(toEmail.getTos()));
        return Boolean.TRUE;
    }

    @Override
    public Boolean enclosureEmail(ToEmail toEmail, File file) {
        MimeMessage message = this.mailSender.createMimeMessage();
        MimeMessageHelper helper = new MimeMessageHelper(message, true);
        helper.setFrom(this.from);
        helper.setTo(toEmail.getTos());
        helper.setSubject(toEmail.getSubject());
        helper.setText(toEmail.getContent(), true);
        FileSystemResource fileSystemResource = new FileSystemResource(file);
        String filename = fileSystemResource.getFilename();
        helper.addAttachment(filename, file);
        this.mailSender.send(message);
        log.info("\u90ae\u4ef6\u53d1\u9001\u6210\u529f -\u300b {}", Arrays.asList(toEmail.getTos()));
        return Boolean.TRUE;
    }

    public DefaultEmailTemplate(JavaMailSender mailSender) {
        this.mailSender = mailSender;
    }
}

