/*
 * Decompiled with CFR 0.152.
 */
package com.pig4cloud.pigx.common.api.encrypt;

import com.pig4cloud.pigx.common.api.encrypt.config.ApiEncryptParamConfiguration;
import com.pig4cloud.pigx.common.api.encrypt.config.ApiEncryptProperties;
import com.pig4cloud.pigx.common.api.encrypt.core.ApiDecryptRequestBodyAdvice;
import com.pig4cloud.pigx.common.api.encrypt.core.ApiEncryptResponseBodyAdvice;
import com.pig4cloud.pigx.common.api.encrypt.core.DefaultSecretKeyResolver;
import com.pig4cloud.pigx.common.api.encrypt.core.ISecretKeyResolver;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={ApiEncryptProperties.class})
@Import(value={ApiEncryptParamConfiguration.class, ApiDecryptRequestBodyAdvice.class, ApiEncryptResponseBodyAdvice.class})
@ConditionalOnProperty(value={"security.api.encrypt.enable"}, havingValue="true", matchIfMissing=true)
public class ApiEncryptAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public ISecretKeyResolver secretKeyResolver(ApiEncryptProperties apiEncryptProperties) {
        return new DefaultSecretKeyResolver(apiEncryptProperties);
    }
}

