/*
 * Decompiled with CFR 0.152.
 */
package com.pig4cloud.pigx.common.api.encrypt.core;

import cn.hutool.core.util.StrUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.pig4cloud.pigx.common.api.encrypt.annotation.decrypt.ApiDecrypt;
import com.pig4cloud.pigx.common.api.encrypt.bean.CryptoInfoBean;
import com.pig4cloud.pigx.common.api.encrypt.config.ApiEncryptProperties;
import com.pig4cloud.pigx.common.api.encrypt.util.ApiCryptoUtil;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Parameter;
import java.nio.charset.StandardCharsets;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.lang.Nullable;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class ApiDecryptParamResolver
implements HandlerMethodArgumentResolver {
    private final ApiEncryptProperties properties;
    private final ObjectMapper objectMapper;

    public boolean supportsParameter(MethodParameter parameter) {
        return AnnotatedElementUtils.hasAnnotation((AnnotatedElement)parameter.getParameter(), ApiDecrypt.class);
    }

    @Nullable
    public Object resolveArgument(MethodParameter methodParameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        Parameter parameter = methodParameter.getParameter();
        ApiDecrypt apiDecrypt = (ApiDecrypt)AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)parameter, ApiDecrypt.class);
        String text = webRequest.getParameter(this.properties.getParamName());
        if (StrUtil.isBlank((CharSequence)text)) {
            return null;
        }
        CryptoInfoBean infoBean = new CryptoInfoBean(apiDecrypt.value(), apiDecrypt.secretKey());
        byte[] textBytes = text.getBytes(StandardCharsets.UTF_8);
        byte[] decryptData = ApiCryptoUtil.decryptData(textBytes, infoBean);
        return this.objectMapper.readValue(decryptData, parameter.getType());
    }

    public ApiDecryptParamResolver(ApiEncryptProperties properties, ObjectMapper objectMapper) {
        this.properties = properties;
        this.objectMapper = objectMapper;
    }
}

